
-- Remanola Novation Launchpad Codec
-- Copyright 2018 Niklas Jakobsson <nico@niconet.se>

-- This file is part of Remanola.

-- Remanola is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- Remanola is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with Remanola.  If not, see <http://www.gnu.org/licenses/>.

DEVICE_ID=0x51

WHITE="ffffff"
HGREY="808080"
DGREY="101010"

RED="ff0000"
HRED="400000"
DRED="100000"

GREEN="00ff00"
HGREEN="004000"
DGREEN="001000"

BLUE="0000ff"
HBLUE="000040"
DBLUE="000010"

YELLOW="ffff00"
HYELLOW="404000"
DYELLOW="101000"

MAGENTA="ff00ff"
HMAGENTA="400040"
DMAGENTA="100010"

CYAN="00ffff"
HCYAN="004040"
DCYAN="001010"

NOCOLOR="000000"

-- Mix colors

ORANGE="ff8000"
HORANGE="402000"
DORANGE="100800"

AMBER="ff4000"
HAMBER="401000"
DAMBER="100500"

GOLD="ffd700"
HGOLD="403500"
DGOLD="100800"

MARINE="7fffd4"
HMARINE="1F4035"
DMARINE="08100d"

CADET="5f9ea0"
HCADET="182829"
DCADET="060a0b"

PINK="ff69b4"
HPINK="401a2d"
DPINK="10070b"

-- Legacy colors
WRED=DRED

WGREEN=DGREEN

--AMBER="ff5515"
WAMBER="401300"

WYELLOW=DYELLOW
YELLOW3="888822"

-- Redrum sequencer
REDRUM_HARD=HRED
REDRUM_MEDIUM=ORANGE
REDRUM_SOFT=YELLOW
REDRUM_HIT=RED
REDRUM_NOHIT=DGREY

-- Thor sequencer
THOR_SEQ_ACTIVE=YELLOW
THOR_SEQ_STEPON=RED
THOR_SEQ_STEPOFF=DGREY

-- Short name color style
S_RED=5
S_WRED=7
S_YELLOW=13
S_WYELLOW=15
S_NOCOLOR=0
MIDI_OUT_GETVERSION = "f0 00 20 29 00 70 f7"
MIDI_OUT_DEVICEINQ = "f0 7e 7f 06 01 f7"

MIDI_IN_DEVICEINQ_HEAD = "f0 7e 00 06 02 00 20 29"

MIDI_OUT_SCROLL = "f0 00 20 29 02 10 14"
MIDI_OUT_ENDSCROLL = MIDI_OUT_SCROLL.." f7"
MIDI_OUT_PROGLAYOUT = "f0 00 20 29 02 10 2c 03 F7"

MIDI_IN_SCROLLEND = "f0 00 20 29 02 10 15 f7"
MIDI_IN_PROGLAYOUT_STATUS = "f0 00 20 29 02 10 2f 03 F7"

gradient={
	[1]=WGREEN,
	[2]=GREEN,
	[3]=YELLOW,
	[4]=ORANGE,
	[5]=AMBER,
	[6]=WAMBER,
	[7]=RED,
	[8]=WRED,
}

brightness={
	[1]="0d",
	[2]="08",
	[3]="04",
	[4]="02",
	[5]="00",
}

item_bvmap={
	["Default"]={
		[1]=127,
		[2]=113,
		[3]=100,
		[4]=75,
		[5]=63,
		[6]=40,
		[7]=20,
		[8]=0,
	},
	["Fader64"]={
		[1]=127,
		[2]=113,
		[3]=100,
		[4]=75,
		[5]=64,
		[6]=40,
		[7]=20,
		[8]=0,
	},
	["MeterSI"]={
		[1]=63,
		[2]=55,
		[3]=48,
		[4]=40,
		[5]=32,
		[6]=24,
		[7]=16,
		[8]=11,
	},
	["Fader VC"]={
		[1]=127,
		[2]=108,
		[3]=89,
		[4]=71,
		[5]=53,
		[6]=36,
		[7]=18,
		[8]=0,
	},
	["BigFader"]={
		[1]=1023,
		[2]=876,
		[3]=751,
		[4]=631,
		[5]=511,
		[6]=340,
		[7]=170,
		[8]=0,
	},
	["Knob V"]={
		[1]=127,
		[2]=111,
		[3]=95,
		[4]=79,
		[5]=47,
		[6]=31,
		[7]=15,
		[8]=0,
	},
	["Knob H"]={
		[1]=0,
		[2]=15,
		[3]=31,
		[4]=47,
		[5]=79,
		[6]=95,
		[7]=111,
		[8]=127,
	},
	["Drawbar"]={
		[1]=0,
		[2]=20,
		[3]=40,
		[4]=63,
		[5]=80,
		[6]=100,
		[7]=113,
		[8]=127,
	},
	["Meter"]={
		[1]=45,
		[2]=39,
		[3]=33,
		[4]=27,
		[5]=21,
		[6]=15,
		[7]=8,
		[8]=1,
	},
	["MeterPeak"]={
		[1]=127,
		[2]=111,
		[3]=95,
		[4]=79,
		[5]=47,
		[6]=31,
		[7]=15,
		[8]=0,
	},
}

button_to_padnote={
        ["Button 8-1"]=36,
        ["Button 8-2"]=37,
        ["Button 8-3"]=38,
        ["Button 8-4"]=39,
        ["Button 7-1"]=40,
        ["Button 7-2"]=41,
        ["Button 7-3"]=42,
        ["Button 7-4"]=43,
        ["Button 6-1"]=44,
        ["Button 6-2"]=45,
        ["Button 6-3"]=46,
        ["Button 6-4"]=47,
        ["Button 5-1"]=48,
        ["Button 5-2"]=49,
        ["Button 5-3"]=50,
        ["Button 5-4"]=51,
}

button_to_fullpadnote={
	-- DL
        ["Button 8-1"]=36,
        ["Button 8-2"]=37,
        ["Button 8-3"]=38,
        ["Button 8-4"]=39,
        ["Button 7-1"]=40,
        ["Button 7-2"]=41,
        ["Button 7-3"]=42,
        ["Button 7-4"]=43,
        ["Button 6-1"]=44,
        ["Button 6-2"]=45,
        ["Button 6-3"]=46,
        ["Button 6-4"]=47,
        ["Button 5-1"]=48,
        ["Button 5-2"]=49,
        ["Button 5-3"]=50,
        ["Button 5-4"]=51,
	-- UL
        ["button 4-1"]=52,
        ["button 4-2"]=53,
        ["button 4-3"]=54,
        ["button 4-4"]=55,
        ["button 3-1"]=56,
        ["button 3-2"]=57,
        ["button 3-3"]=58,
        ["button 3-4"]=59,
        ["button 2-1"]=60,
        ["button 2-2"]=61,
        ["button 2-3"]=62,
        ["button 2-4"]=63,
        ["button 1-1"]=64,
        ["button 1-2"]=65,
        ["button 1-3"]=66,
        ["button 1-4"]=67,
	-- DR
        ["Button 8-5"]=68,
        ["Button 8-6"]=69,
        ["Button 8-7"]=70,
        ["Button 8-8"]=71,
        ["Button 7-5"]=72,
        ["Button 7-6"]=73,
        ["Button 7-7"]=74,
        ["Button 7-8"]=75,
        ["Button 6-5"]=76,
        ["Button 6-6"]=77,
        ["Button 6-7"]=78,
        ["Button 6-8"]=79,
        ["Button 5-5"]=80,
        ["Button 5-6"]=81,
        ["Button 5-7"]=82,
        ["Button 5-8"]=83,
	-- UR
        ["Button 4-5"]=84,
        ["Button 4-6"]=85,
        ["Button 4-7"]=86,
        ["Button 4-8"]=87,
        ["Button 3-5"]=88,
        ["Button 3-6"]=89,
        ["Button 3-7"]=90,
        ["Button 3-8"]=91,
        ["Button 2-5"]=92,
        ["Button 2-6"]=93,
        ["Button 2-7"]=94,
        ["Button 2-8"]=95,
        ["Button 1-5"]=96,
        ["Button 1-6"]=97,
        ["Button 1-7"]=98,
        ["Button 1-8"]=99,
}

button_to_keynote={
	-- C0
	["Button 8-2"]=24,
       	["Button 7-2"]=25,
	["Button 8-3"]=26,
       	["Button 7-3"]=27,
      	["Button 8-4"]=28,
       	["Button 8-5"]=29,
       	["Button 7-5"]=30,
       	["Button 8-6"]=31,
       	["Button 7-6"]=32,
       	["Button 8-7"]=33,
       	["Button 7-7"]=34,
       	["Button 8-8"]=35,
	-- C1
	["Button 6-2"]=36,
       	["Button 5-2"]=37,
	["Button 6-3"]=38,
       	["Button 5-3"]=39,
      	["Button 6-4"]=40,
       	["Button 6-5"]=41,
       	["Button 5-5"]=42,
       	["Button 6-6"]=43,
       	["Button 5-6"]=44,
       	["Button 6-7"]=45,
       	["Button 5-7"]=46,
       	["Button 6-8"]=47,
	-- C2
	["Button 4-2"]=48,
       	["Button 3-2"]=49,
	["Button 4-3"]=50,
       	["Button 3-3"]=51,
      	["Button 4-4"]=52,
       	["Button 4-5"]=53,
       	["Button 3-5"]=54,
       	["Button 4-6"]=55,
       	["Button 3-6"]=56,
       	["Button 4-7"]=57,
       	["Button 3-7"]=58,
       	["Button 4-8"]=59,
}

local buttons = {
	["Button 1-1"]="90 51",
	["Button 1-2"]="90 52",
	["Button 1-3"]="90 53",
	["Button 1-4"]="90 54",
	["Button 1-5"]="90 55",
	["Button 1-6"]="90 56",
	["Button 1-7"]="90 57",
	["Button 1-8"]="90 58",
	
	["Button 2-1"]="90 47",
	["Button 2-2"]="90 48",
	["Button 2-3"]="90 49",
	["Button 2-4"]="90 4a",
	["Button 2-5"]="90 4b",
	["Button 2-6"]="90 4c",
	["Button 2-7"]="90 4d",
	["Button 2-8"]="90 4e",

	["Button 3-1"]="90 3d",
	["Button 3-2"]="90 3e",
	["Button 3-3"]="90 3f",
	["Button 3-4"]="90 40",
	["Button 3-5"]="90 41",
	["Button 3-6"]="90 42",
	["Button 3-7"]="90 43",
	["Button 3-8"]="90 44",
	
	["Button 4-1"]="90 33",
	["Button 4-2"]="90 34",
	["Button 4-3"]="90 35",
	["Button 4-4"]="90 36",
	["Button 4-5"]="90 37",
	["Button 4-6"]="90 38",
	["Button 4-7"]="90 39",
	["Button 4-8"]="90 3a",
	
	["Button 5-1"]="90 29",
	["Button 5-2"]="90 2a",
	["Button 5-3"]="90 2b",
	["Button 5-4"]="90 2c",
	["Button 5-5"]="90 2d",
	["Button 5-6"]="90 2e",
	["Button 5-7"]="90 2f",
	["Button 5-8"]="90 30",
	
	["Button 6-1"]="90 1f",
	["Button 6-2"]="90 20",
	["Button 6-3"]="90 21",
	["Button 6-4"]="90 22",
	["Button 6-5"]="90 23",
	["Button 6-6"]="90 24",
	["Button 6-7"]="90 25",
	["Button 6-8"]="90 26",
		
	["Button 7-1"]="90 15",
	["Button 7-2"]="90 16",
	["Button 7-3"]="90 17",
	["Button 7-4"]="90 18",
	["Button 7-5"]="90 19",
	["Button 7-6"]="90 1a",
	["Button 7-7"]="90 1b",
	["Button 7-8"]="90 1c",
	
	["Button 8-1"]="90 0b",
	["Button 8-2"]="90 0c",
	["Button 8-3"]="90 0d",
	["Button 8-4"]="90 0e",
	["Button 8-5"]="90 0f",
	["Button 8-6"]="90 10",
	["Button 8-7"]="90 11",
	["Button 8-8"]="90 12",
	
	-- Bottom
	["Button A0"]="b0 00", -- Hidden
	["Button A1"]="b0 01",
	["Button A2"]="b0 02",
	["Button A3"]="b0 03",
	["Button A4"]="b0 04",
	["Button A5"]="b0 05",
	["Button A6"]="b0 06",
	["Button A7"]="b0 07",
	["Button A8"]="b0 08",
	["Button A9"]="b0 09", -- Hidden

	-- Left
	["Button B1"]="b0 50",
	["Button B2"]="b0 46",
	["Button B3"]="b0 3c",
	["Button B4"]="b0 32",
	["Button B5"]="b0 28",
	["Button B6"]="b0 1e",
	["Button B7"]="b0 14",
	["Button B8"]="b0 0a",

	-- Top
	["Button C0"]="b0 5a", -- Hidden
	["Button C1"]="b0 5b",
	["Button C2"]="b0 5c",
	["Button C3"]="b0 5d",
	["Button C4"]="b0 5e",
	["Button C5"]="b0 5f",
	["Button C6"]="b0 60",
	["Button C7"]="b0 61",
	["Button C8"]="b0 62",
	["Button C9"]="b0 63", -- Hidden

	-- Right
	["Button D1"]="b0 59", 
	["Button D2"]="b0 4f", 
	["Button D3"]="b0 45", 
	["Button D4"]="b0 3b", 
	["Button D5"]="b0 31", 
	["Button D6"]="b0 27", 
	["Button D7"]="b0 1d", 
	["Button D8"]="b0 13",
}	

g_scopetext = "none"
g_colorscheme = "Default"
g_scopetext_saved = ""
g_colorscheme_saved = ""
g_brightness = 4
g_brightness_new = 4
g_helpmode = false
g_valuemode = false
g_scrolltext = nil
g_scrollcolor_default = 13
g_scrollcolor = g_scrollcolor_default
g_scrolling = false
g_scrollspeed_default = 5
g_scrollspeed = g_scrollspeed_default
g_scrolltime = nil
g_playingbutton = 1
g_flashing = false
g_flashstate = 0
g_flashlength = 250
g_flashtime = nil
g_stopflashing = false
g_startflashing = false
g_lightshow = 0
g_lightshowtime = nil
g_lightshowcycle = 1
g_lightshowloop = 1
g_updatetime = nil
g_sel = {}
g_selcount = 4
g_select = {}
g_cpage = nil
g_cstep = nil
g_updateall = true
g_currentbuffer = 0
g_startbar = false
g_barupdate = false
g_barupdatetime = nil
g_startbeat = false
g_beatupdate = false
g_beatupdatetime = nil
g_basekey = 2
g_kbdvel = 100

g_updateditems = {}

local inputs = {}
local outputs = {}

local itemsindex = {}
local itemsmodeindex = {}

midi_to_button = {}

local color_templates = {
	-- Fader and Knob
	["FAmber"]={enabledcolor=DGREEN, activecolor=AMBER},
	["FRed"]={enabledcolor=DGREEN, activecolor=RED},
	["FGreen"]={enabledcolor=DGREEN, activecolor=GREEN},
	["FYellow"]={enabledcolor=DGREEN, activecolor=YELLOW},
	["FOrange"]={enabledcolor=DGREEN, activecolor=ORANGE},
	-- Faders by type
	["FOsc"]={enabledcolor=DAMBER, activecolor=AMBER},
	["FVol"]={enabledcolor=DMAGENTA, activecolor=MAGENTA},
	["FPan"]={enabledcolor=DMAGENTA, activecolor=MAGENTA},
	["FAmount"]={enabledcolor=DRED, activecolor=RED},
	["FGain"]={enabledcolor=DRED, activecolor=RED},
	["FFreq"]={enabledcolor=DGREEN, activecolor=GREEN},
	["FMisc"]={enabledcolor=DPINK, activecolor=PINK},
	["FLFO"]={enabledcolor=DYELLOW, activecolor=YELLOW},
	["FEnv"]={enabledcolor=DYELLOW, activecolor=YELLOW},
	["FPerf"]={enabledcolor=DCYAN, activecolor=CYAN},
	["FEffect"]={enabledcolor=DBLUE, activecolor=BLUE},
	-- Mix Channel
	["FMixComp"]={enabledcolor=DGREEN, activecolor=GREEN},
	["FMixGate"]={enabledcolor=DRED, activecolor=RED},
	["FMixFilter"]={enabledcolor=DORANGE, activecolor=ORANGE},
	["FMixEqHF"]={enabledcolor=DRED, activecolor=RED},
	["FMixEqHMF"]={enabledcolor=DGREEN, activecolor=GREEN},
	["FMixEqLMF"]={enabledcolor=DBLUE, activecolor=BLUE},
	["FMixEqLF"]={enabledcolor=DPINK, activecolor=PINK},
	-- Drawbars
	["DSub"]={enabledcolor=DRED, activecolor=RED},
	["DFund"]={enabledcolor=DGREY, activecolor=WHITE},
	["DHarm"]={enabledcolor=DBLUE, activecolor=BLUE},
	["DHarm7"]={enabledcolor=DCYAN, activecolor=CYAN},
	-- Special Vocoder Fader
	["FVCGreen"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR, denabledcolor=WAMBER, dactivecolor=YELLOW, defaultvalue=89},
	["FVCFreq"]={enabledcolor=DGREEN, activecolor=GREEN, disabledcolor=NOCOLOR, denabledcolor=WAMBER, dactivecolor=YELLOW, defaultvalue=89},
	-- Fader with default value
	["FAmberDef100"]={enabledcolor=DGREEN, activecolor=AMBER, denabledcolor=WAMBER, dactivecolor=RED, defaultvalue=100},
	["FRedDef100"]={enabledcolor=DGREEN, activecolor=RED, denabledcolor=WAMBER, dactivecolor=ORANGE, defaultvalue=100},
	["FGreenDef100"]={enabledcolor=WAMBER, activecolor=GREEN, denabledcolor=DGREEN, dactivecolor=YELLOW, defaultvalue=100},
	["FYellowDef100"]={enabledcolor=DGREEN, activecolor=YELLOW, denabledcolor=WAMBER, dactivecolor=RED, defaultvalue=100},
	["FOrangeDef100"]={enabledcolor=DGREEN, activecolor=ORANGE, denabledcolor=WAMBER, dactivecolor=RED, defaultvalue=100},
	-- Meters
	["InvMeter"]={enabledcolor=GREEN,      activecolor=DGREEN,     disabledcolor=NOCOLOR, maxcolor=RED},
	["MRed"]={enabledcolor=WAMBER, activecolor=RED, disabledcolor=NOCOLOR, maxcolor=RED},
	-- Up/Down Buttons
	["UDAmber"]={enabledcolor=AMBER, activecolor=AMBER},
	["UDAmber2"]={enabledcolor=HAMBER, activecolor=HAMBER},
	["UDRed"]={enabledcolor=RED, activecolor=RED},
	["UDGreen"]={enabledcolor=GREEN, activecolor=GREEN},
	["UDYellow"]={enabledcolor=YELLOW, activecolor=YELLOW},
	["UDYellow3"]={enabledcolor=HYELLOW, activecolor=HYELLOW},
	["UDOrange"]={enabledcolor=ORANGE, activecolor=ORANGE},
	["UDNocolor"]={enabledcolor=NOCOLOR, activecolor=NOCOLOR},
	-- UD by type
	["UDOsc"]={enabledcolor=AMBER, activecolor=AMBER},
	["UDOsc2"]={enabledcolor=HAMBER, activecolor=HAMBER},
	["UDAmount"]={enabledcolor=RED, activecolor=RED},
	["UDAmount2"]={enabledcolor=HRED, activecolor=HRED},
	["UDVol"]={enabledcolor=MAGENTA, activecolor=MAGENTA},
	["UDVol2"]={enabledcolor=HMAGENTA, activecolor=HMAGENTA},
	["UDGain"]={enabledcolor=RED, activecolor=RED},
	["UDGain2"]={enabledcolor=HRED, activecolor=HRED},
	["UDFreq"]={enabledcolor=GREEN, activecolor=GREEN},
	["UDFreq2"]={enabledcolor=HGREEN, activecolor=HGREEN},
	["UDMisc"]={enabledcolor=PINK, activecolor=PINK},
	["UDMisc2"]={enabledcolor=HPINK, activecolor=HPINK},
	["UDLFO"]={enabledcolor=YELLOW, activecolor=YELLOW},
	["UDLFO2"]={enabledcolor=HYELLOW, activecolor=HYELLOW},
	["UDEnv"]={enabledcolor=YELLOW, activecolor=YELLOW},
	["UDEnv2"]={enabledcolor=HYELLOW, activecolor=HYELLOW},
	["UDEffect"]={enabledcolor=BLUE, activecolor=BLUE},
	["UDEffect2"]={enabledcolor=HBLUE, activecolor=HBLUE},
	["UDPerf"]={enabledcolor=CYAN, activecolor=CYAN},
	["UDPerf2"]={enabledcolor=HCYAN, activecolor=HCYAN},
	-- Buttons
	["BAmber"]={enabledcolor=AMBER, activecolor=AMBER,  disabledcolor=NOCOLOR},
	["BRed"]={enabledcolor=RED, activecolor=RED,  disabledcolor=NOCOLOR},
	["BGreen"]={enabledcolor=GREEN, activecolor=GREEN,  disabledcolor=NOCOLOR},
	["BYellow"]={enabledcolor=YELLOW, activecolor=YELLOW,  disabledcolor=NOCOLOR},
	["BYellow3"]={enabledcolor=YELLOW3, activecolor=YELLOW3,  disabledcolor=NOCOLOR},
	["BOrange"]={enabledcolor=ORANGE, activecolor=ORANGE,  disabledcolor=NOCOLOR},
	-- Button On/Off 
	["BRedOnOff"]={enabledcolor=HGREY,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BYellowOnOff"]={enabledcolor=HGREY,   activecolor=YELLOW,  disabledcolor=NOCOLOR},
	["BGreenOnOff"]={enabledcolor=HGREY,   activecolor=GREEN,  disabledcolor=NOCOLOR},
	["BAmberOnOff"]={enabledcolor=HGREY,   activecolor=AMBER,  disabledcolor=NOCOLOR},
	["BBlueOnOff"]={enabledcolor=HGREY,   activecolor=BLUE,  disabledcolor=NOCOLOR},
	["BBGreenOnOff"]={enabledcolor=DGREEN,   activecolor=GREEN,  disabledcolor=NOCOLOR},
	["BBRedOnOff"]={enabledcolor=DRED,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BBBlueOnOff"]={enabledcolor=DBLUE,   activecolor=BLUE,  disabledcolor=NOCOLOR},
	["BPerfOnOff"]={enabledcolor=DCYAN,   activecolor=CYAN,  disabledcolor=NOCOLOR},
	-- Button On/OFf Mix channel
	["BMixOnOff"]={enabledcolor=HGREY,   activecolor=BLUE,  disabledcolor=NOCOLOR},
	-- Red LED
	["BRedLed"]={enabledcolor=DGREEN,   activecolor=RED,  disabledcolor=NOCOLOR},
	-- Button Page
	["BMainPage"]={enabledcolor=WHITE,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BIndexPage"]={enabledcolor=WHITE,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BAmpPage"]={enabledcolor=MAGENTA,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BAmpModPage"]={enabledcolor=HMAGENTA,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BOscPage"]={enabledcolor=AMBER,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BOscModPage"]={enabledcolor=WAMBER,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BFilterPage"]={enabledcolor=GREEN,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BFilterModPage"]={enabledcolor=DGREEN,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BMainEffectPage"]={enabledcolor=HBLUE,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BEffectPage"]={enabledcolor=BLUE,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BEffect2Page"]={enabledcolor=HBLUE,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BEqPage"]={enabledcolor=HGREEN,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BEffectSupPage"]={enabledcolor=DBLUE,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BPerformancePage"]={enabledcolor=CYAN,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BPerfPage"]={enabledcolor=CYAN,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BLFOPage"]={enabledcolor=YELLOW,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BEnvPage"]={enabledcolor=HYELLOW,   activecolor=RED,  disabledcolor=NOCOLOR},
	-- Mute/Solo
	["BMute"]={enabledcolor=DRED,   activecolor=RED,  disabledcolor=NOCOLOR},
	["BSolo"]={enabledcolor=WAMBER,   activecolor=GREEN,  disabledcolor=NOCOLOR},
	["BSolo"]={enabledcolor=WAMBER,   activecolor=GREEN,  disabledcolor=NOCOLOR},
	["BSoloRevival"]={enabledcolor=WAMBER,   activecolor=YELLOW,  disabledcolor=NOCOLOR},
	-- Select
	["BPlaySel"]={enabledcolor=DGREEN, activecolor=GREEN,  disabledcolor=NOCOLOR},
	["BOscSel"]={enabledcolor=DAMBER, activecolor=AMBER,  disabledcolor=NOCOLOR},
	-- Run
	["BRun"]={enabledcolor=RED,   activecolor=GREEN,  disabledcolor=NOCOLOR},
	-- Bank / Pattern Select
	["BBank"]={enabledcolor=WAMBER,   activecolor=RED,  disabledcolor=NOCOLOR},
	-- Sel sound/cat
	["BSelCat"]={enabledcolor=AMBER,   activecolor=AMBER,  disabledcolor=NOCOLOR},
	["BSelSound"]={enabledcolor=WAMBER,   activecolor=AMBER,  disabledcolor=NOCOLOR},
	-- Step sequencer
	["BStep"]={enabledcolor=DGREEN,   activecolor=RED,  disabledcolor=NOCOLOR},
	-- Kong Pad
	["BPad"]={enabledcolor=DGREEN,   activecolor=GREEN,  disabledcolor=NOCOLOR},
	-- Keyboard page Pad
	["BULPad"]={enabledcolor=MAGENTA,   activecolor=MAGENTA,  disabledcolor=MAGENTA},
	["BURPad"]={enabledcolor=GREEN,   activecolor=GREEN,  disabledcolor=GREEN},
	["BDLPad"]={enabledcolor=YELLOW,   activecolor=YELLOW,  disabledcolor=YELLOW},
	["BDRPad"]={enabledcolor=CYAN,   activecolor=CYAN,  disabledcolor=CYAN},
	-- Keyboard
	["BWhitekey"]={enabledcolor=WHITE,   activecolor=WHITE,  disabledcolor=WHITE},
	["BBlackkey"]={enabledcolor=BLUE,   activecolor=BLUE,  disabledcolor=BLUE},
}
local item_conf_map = {
	["Default"]={
		["Default"]={
			["Button *"]={enabledcolor=YELLOW,    activecolor=GREEN,  disabledcolor=NOCOLOR},
			["Fader *"]={template="FYellow"},
			["BigFader *"]={enabledcolor=WAMBER,      activecolor=GREEN,     disabledcolor=NOCOLOR, denabledcolor=WGREEN, dactivecolor=YELLOW, defaultvalue=751},
			["Drawbar *"]={ttemplate="FYellow"},
			["Meter *"]={enabledcolor=WAMBER,      activecolor=GREEN,     disabledcolor=NOCOLOR, maxcolor=RED},
			["Knob *"]={template="FYellow"},
			["UDHButton *"]={enabledcolor=YELLOW,      activecolor=YELLOW,     disabledcolor=NOCOLOR},
			["UDVButton *"]={enabledcolor=YELLOW,      activecolor=YELLOW,     disabledcolor=NOCOLOR},

			["Button D1"]={enabledcolor=WGREEN,   activecolor=WGREEN,  disabledcolor=NOCOLOR}, 
			["Button D2"]={enabledcolor=ORANGE,    activecolor=YELLOW,   disabledcolor=NOCOLOR}, 
			["Button D3"]={enabledcolor=WRED,      activecolor=RED,    disabledcolor=NOCOLOR}, 
			["Button D4"]={enabledcolor=WAMBER,   activecolor=GREEN,   disabledcolor=NOCOLOR}, 
			["Button D5"]={enabledcolor=WAMBER,      activecolor=GREEN,  disabledcolor=NOCOLOR}, 
			["Button D6"]={enabledcolor=YELLOW,      activecolor=GREEN,  disabledcolor=NOCOLOR}, 
			["Button D7"]={enabledcolor=YELLOW,      activecolor=GREEN,  disabledcolor=NOCOLOR}, 
			["Button D8"]={enabledcolor=RED,      activecolor=AMBER,  disabledcolor=NOCOLOR},
		
			["Button C1"]={enabledcolor=ORANGE,   activecolor=ORANGE,  disabledcolor=NOCOLOR},
			["Button C2"]={enabledcolor=ORANGE,   activecolor=ORANGE,  disabledcolor=NOCOLOR},
			["Button C3"]={enabledcolor=GREEN,    activecolor=GREEN,   disabledcolor=NOCOLOR},
			["Button C4"]={enabledcolor=GREEN,    activecolor=GREEN,   disabledcolor=NOCOLOR},
			["Button C6"]={template="BPerfPage"},
			["Button C7"]={template="BIndexPage"},
			["Button C8"]={enabledcolor=YELLOW,      activecolor=RED,     disabledcolor=GREEN},
			["Button B1"]={template="BMainPage"}, 

			["Side LED"]={enabledcolor=GREEN,      activecolor=GREEN,     disabledcolor=GREEN},
		},
		["Index"]={
			["Button C7"]={enabledcolor=AMBER,      activecolor=AMBER,     disabledcolor=NOCOLOR},
			["Button 1-1"]={template="BMainPage", helptext="Goto Main"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 5-1"]={template="BOscPage"},
			["Button 6-1"]={template="BOscPage"},
			["Button 7-1"]={template="BOscPage"},
			["Button 8-1"]={template="BOscPage"},

			["Button 1-2"]={template="BAmpPage"},
			["Button 2-2"]={template="BOscModPage"},
			["Button 3-2"]={template="BOscModPage"},
			["Button 4-2"]={template="BOscModPage"},
			["Button 5-2"]={template="BOscModPage"},
			["Button 6-2"]={template="BOscModPage"},
			["Button 7-2"]={template="BOscModPage"},
			["Button 8-2"]={template="BOscModPage"},

			["Button 1-3"]={template="BAmpPage"},
			["Button 2-3"]={template="BOscModPage"},
			["Button 3-3"]={template="BOscModPage"},
			["Button 4-3"]={template="BOscModPage"},
			["Button 5-3"]={template="BOscModPage"},
			["Button 6-3"]={template="BOscModPage"},
			["Button 7-3"]={template="BOscModPage"},
			["Button 8-3"]={template="BOscModPage"},

			["Button 1-4"]={template="BAmpPage"},
			["Button 2-4"]={template="BOscModPage"},
			["Button 3-4"]={template="BOscModPage"},
			["Button 4-4"]={template="BOscModPage"},
			["Button 5-4"]={template="BOscModPage"},
			["Button 6-4"]={template="BOscModPage"},
			["Button 7-4"]={template="BOscModPage"},
			["Button 8-4"]={template="BOscModPage"},

			["Button 1-5"]={template="BPerformancePage"},
			["Button 2-5"]={template="BFilterPage"},
			["Button 3-5"]={template="BFilterPage"},
			["Button 4-5"]={template="BFilterPage"},
			["Button 5-5"]={template="BLFOPage"},
			["Button 6-5"]={template="BLFOPage"},
			["Button 7-5"]={template="BLFOPage"},
			["Button 8-5"]={template="BLFOPage"},

			["Button 1-6"]={template="BPerformancePage"},
			["Button 2-6"]={template="BFilterModPage"},
			["Button 3-6"]={template="BFilterModPage"},
			["Button 4-6"]={template="BFilterModPage"},
			["Button 5-6"]={template="BEnvPage"},
			["Button 6-6"]={template="BEnvPage"},
			["Button 7-6"]={template="BEnvPage"},
			["Button 8-6"]={template="BEnvPage"},

			["Button 1-7"]={template="BPerformancePage"},
			["Button 2-7"]={template="BEffectPage"},
			["Button 3-7"]={template="BEffectPage"},
			["Button 4-7"]={template="BEffectPage"},
			["Button 5-7"]={template="BEffectPage"},
			["Button 6-7"]={template="BEffectPage"},
			["Button 7-7"]={template="BEffectPage"},
			["Button 8-7"]={template="BEffectPage"},

			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			["Button 8-8"]={template="BEffectPage"},
		},
		["Internal"]={
			["Button C7"]={enabledcolor=RED,      activecolor=RED,     disabledcolor=NOCOLOR},
			["Button 1-1"]={template="BMainPage"},
			["Button C1"]={enabledcolor=NOCOLOR,   activecolor=ORANGE,  disabledcolor=NOCOLOR},
			["Button C2"]={enabledcolor=NOCOLOR,   activecolor=ORANGE,  disabledcolor=NOCOLOR},
			["Button C3"]={enabledcolor=NOCOLOR,    activecolor=GREEN,   disabledcolor=NOCOLOR},
			["Button C4"]={enabledcolor=NOCOLOR,    activecolor=GREEN,   disabledcolor=NOCOLOR},
			["Button H"]={enabledcolor=YELLOW,      activecolor=GREEN,  disabledcolor=NOCOLOR},
			-- Color test
			["Button 2-1"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=RED},
			["Button 3-1"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HRED},
			["Button 4-1"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DRED},

			["Button 2-2"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=YELLOW},
			["Button 3-2"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HYELLOW},
			["Button 4-2"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DYELLOW},

			["Button 2-3"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=GREEN},
			["Button 3-3"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HGREEN},
			["Button 4-3"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DGREEN},

			["Button 2-4"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=CYAN},
			["Button 3-4"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HCYAN},
			["Button 4-4"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DCYAN},

			["Button 2-5"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=BLUE},
			["Button 3-5"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HBLUE},
			["Button 4-5"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DBLUE},

			["Button 2-6"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=MAGENTA},
			["Button 3-6"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HMAGENTA},
			["Button 4-6"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DMAGENTA},

			["Button 2-8"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=WHITE},
			["Button 3-8"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HGREY},
			["Button 4-8"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DGREY},

			["Button 5-1"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=AMBER},
			["Button 6-1"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HAMBER},
			["Button 7-1"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DAMBER},

			["Button 5-2"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=ORANGE},
			["Button 6-2"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HORANGE},
			["Button 7-2"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DORANGE},

			["Button 5-3"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=GOLD},
			["Button 6-3"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HGOLD},
			["Button 7-3"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DGOLD},

			["Button 5-4"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=MARINE},
			["Button 6-4"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=MARINE},
			["Button 7-4"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DMARINE},

			["Button 5-5"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=CADET},
			["Button 6-5"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HCADET},
			["Button 7-5"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DCADET},

			["Button 5-6"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=PINK},
			["Button 6-6"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=HPINK},
			["Button 7-6"]={enabledcolor=NOCOLOR,    activecolor=NOCOLOR,  disabledcolor=DPINK},
		},
		["Keyboard"]={
			["Button A1"]={template="BPerformancePage"},
			["Button A2"]={template="BPerformancePage"},
			["Kbd"]={
				["Button 1-2"]={template="BPerformancePage"},
				["Button 2-2"]={template="BPerformancePage"},
				["Fader 1"]={template="FPerf"},
				["Knob V1"]={template="FFreq", resetonrel=true},
				["UDVButton 1-3_2-3"]={template="UDPerf"},
				["Button 1-4"]={template="BPerformancePage"},
				["Button 1-5"]={template="BPerformancePage"},
				["Button 1-6"]={template="BPerformancePage"},
				["Button 1-7"]={template="BPerformancePage"},
				["Button 1-8"]={template="BPerformancePage"},
				["Button 2-4"]={template="BFilterPage"},
				["Button 2-5"]={template="BFilterPage"},
				["Button 2-6"]={template="BFilterPage"},
				["Button 2-7"]={template="BFilterPage"},
				["Button 2-8"]={template="BFilterPage"},
				--
				["Button 8-2"]={template="BWhitekey"},
				["Button 7-2"]={template="BBlackkey"},
				["Button 8-3"]={template="BWhitekey"},
				["Button 7-3"]={template="BBlackkey"},
				["Button 8-4"]={template="BWhitekey"},
				["Button 8-5"]={template="BWhitekey"},
				["Button 7-5"]={template="BBlackkey"},
				["Button 8-6"]={template="BWhitekey"},
				["Button 7-6"]={template="BBlackkey"},
				["Button 8-7"]={template="BWhitekey"},
				["Button 7-7"]={template="BBlackkey"},
				["Button 8-8"]={template="BWhitekey"},
				--
				["Button 6-2"]={template="BWhitekey"},
				["Button 5-2"]={template="BBlackkey"},
				["Button 6-3"]={template="BWhitekey"},
				["Button 5-3"]={template="BBlackkey"},
				["Button 6-4"]={template="BWhitekey"},
				["Button 6-5"]={template="BWhitekey"},
				["Button 5-5"]={template="BBlackkey"},
				["Button 6-6"]={template="BWhitekey"},
				["Button 5-6"]={template="BBlackkey"},
				["Button 6-7"]={template="BWhitekey"},
				["Button 5-7"]={template="BBlackkey"},
				["Button 6-8"]={template="BWhitekey"},
				--
				["Button 4-2"]={template="BWhitekey"},
				["Button 3-2"]={template="BBlackkey"},
				["Button 4-3"]={template="BWhitekey"},
				["Button 3-3"]={template="BBlackkey"},
				["Button 4-4"]={template="BWhitekey"},
				["Button 4-5"]={template="BWhitekey"},
				["Button 3-5"]={template="BBlackkey"},
				["Button 4-6"]={template="BWhitekey"},
				["Button 3-6"]={template="BBlackkey"},
				["Button 4-7"]={template="BWhitekey"},
				["Button 3-7"]={template="BBlackkey"},
				["Button 4-8"]={template="BWhitekey"},
			},
			["Drum"]={
                        	-- Pads UL
                        	["Button 1-1"]={template="BULPad"},
                        	["Button 1-2"]={template="BULPad"},
                        	["Button 1-3"]={template="BULPad"},
                        	["Button 1-4"]={template="BULPad"},
                        	["Button 2-1"]={template="BULPad"},
                        	["Button 2-2"]={template="BULPad"},
                        	["Button 2-3"]={template="BULPad"},
                        	["Button 2-4"]={template="BULPad"},
                        	["Button 3-1"]={template="BULPad"},
                        	["Button 3-2"]={template="BULPad"},
                        	["Button 3-3"]={template="BULPad"},
                        	["Button 3-4"]={template="BULPad"},
                        	["Button 4-1"]={template="BULPad"},
                        	["Button 4-2"]={template="BULPad"},
                        	["Button 4-3"]={template="BULPad"},
                        	["Button 4-4"]={template="BULPad"},
                        	-- Pads UR
                        	["Button 1-5"]={template="BURPad"},
                        	["Button 1-6"]={template="BURPad"},
                        	["Button 1-7"]={template="BURPad"},
                        	["Button 1-8"]={template="BURPad"},
                        	["Button 2-5"]={template="BURPad"},
                        	["Button 2-6"]={template="BURPad"},
                        	["Button 2-7"]={template="BURPad"},
                        	["Button 2-8"]={template="BURPad"},
                        	["Button 3-5"]={template="BURPad"},
                        	["Button 3-6"]={template="BURPad"},
                        	["Button 3-7"]={template="BURPad"},
                        	["Button 3-8"]={template="BURPad"},
                        	["Button 4-5"]={template="BURPad"},
                        	["Button 4-6"]={template="BURPad"},
                        	["Button 4-7"]={template="BURPad"},
                        	["Button 4-8"]={template="BURPad"},
                        	-- Pads DL
                        	["Button 5-1"]={template="BDLPad"},
                        	["Button 5-2"]={template="BDLPad"},
                        	["Button 5-3"]={template="BDLPad"},
                        	["Button 5-4"]={template="BDLPad"},
                        	["Button 6-1"]={template="BDLPad"},
                        	["Button 6-2"]={template="BDLPad"},
                        	["Button 6-3"]={template="BDLPad"},
                        	["Button 6-4"]={template="BDLPad"},
                        	["Button 7-1"]={template="BDLPad"},
                        	["Button 7-2"]={template="BDLPad"},
                        	["Button 7-3"]={template="BDLPad"},
                        	["Button 7-4"]={template="BDLPad"},
                        	["Button 8-1"]={template="BDLPad"},
                        	["Button 8-2"]={template="BDLPad"},
                        	["Button 8-3"]={template="BDLPad"},
                        	["Button 8-4"]={template="BDLPad"},
                        	-- Pads DR
                        	["Button 5-5"]={template="BDRPad"},
                        	["Button 5-6"]={template="BDRPad"},
                        	["Button 5-7"]={template="BDRPad"},
                        	["Button 5-8"]={template="BDRPad"},
                        	["Button 6-5"]={template="BDRPad"},
                        	["Button 6-6"]={template="BDRPad"},
                        	["Button 6-7"]={template="BDRPad"},
                        	["Button 6-8"]={template="BDRPad"},
                        	["Button 7-5"]={template="BDRPad"},
                        	["Button 7-6"]={template="BDRPad"},
                        	["Button 7-7"]={template="BDRPad"},
                        	["Button 7-8"]={template="BDRPad"},
                        	["Button 8-5"]={template="BDRPad"},
                        	["Button 8-6"]={template="BDRPad"},
                        	["Button 8-7"]={template="BDRPad"},
                        	["Button 8-8"]={template="BDRPad"},
			},
		},
		["Transport"]={
			["Button D1"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR}, 
			["Button D2"]={enabledcolor=ORANGE, activecolor=YELLOW, disabledcolor=NOCOLOR}, 
			["Button D3"]={enabledcolor=WRED, activecolor=RED, disabledcolor=NOCOLOR}, 
			["Button D4"]={enabledcolor=AMBER, activecolor=GREEN, disabledcolor=NOCOLOR}, 
			["Button D5"]={enabledcolor=AMBER, activecolor=GREEN, disabledcolor=NOCOLOR}, 
			["Button D6"]={template="BBGreenOnOff"}, 
			["Button D7"]={template="BBGreenOnOff"}, 
			["Button D8"]={enabledcolor=YELLOW, activecolor=YELLOW, disabledcolor=NOCOLOR},
		
		},
		["Options"]={
			["Button D1"]={template="BRedOnOff"},
			["Button D2"]={template="BRed"},
			["Button D3"]={template="BGreen"},
			["Button D4"]={template="BGreenOnOff"},
			["Button D5"]={template="BRedOnOff"},
			["Button D6"]={template="BRedOnOff"},
			["Button D7"]={template="BRedOnOff"},
			["Button D8"]={enabledcolor=GREEN, activecolor=GREEN, disabledcolor=NOCOLOR},
		},
	},

	["Master Section"]={
		["Default"]={
		},
		["Index"]={
			["Button 1-1"]={template="BMainPage"},
			["Button 1-2"]={template="BAmpPage"},
			["Button 1-3"]={template="BAmpPage"},
			["Button 1-5"]={template="BPerformancePage"},
			["Button 8-1"]={template="BYellow"},
			["Button 8-2"]={template="BYellow"},
			["Button 1-7"]={template="BEffectPage"},
			["Button 2-7"]={template="BEffectPage"},
			["Button 3-7"]={template="BEffectPage"},
			["Button 4-7"]={template="BEffectPage"},
			["Button 5-7"]={template="BEffectPage"},
			["Button 6-7"]={template="BEffectPage"},
			["Button 7-7"]={template="BEffectPage"},
			["Button 8-7"]={template="BEffectPage"},
		},
		["Main"]={
			["Vu"]={
				["Meter 1"]={template="FGreen"},
				["Meter 2"]={template="FGreen"},
			},
			["Peak"]={
				["Meter 1"]={template="FOrange", bvmap="MeterPeak"},
				["Meter 2"]={template="FOrange", bvmap="MeterPeak"},
			},
			["Button 6-4"]={template="BAmpPage"},
			["Button 7-4"]={template="BAmpPage"},
			["Button 8-4"]={template="BRedOnOff"},
			["UDVButton 1-6_2-6"]={template="BRed", inverted=true},
			["UDVButton 1-7_2-7"]={template="BOrange", inverted=true},
			["Fader 5"]={template="FRed"},
			["Button 8-6"]={template="BMute"},
			["Button 8-7"]={template="BSolo"},
			["Button 8-8"]={template="BRedOnOff"},
		},
		["Channel Mutes & Solos"]={
			["Button 1-1"]={template="BMute"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BMute"},
			["Button 1-4"]={template="BMute"},
			["Button 1-5"]={template="BMute"},
			["Button 1-6"]={template="BMute"},
			["Button 1-7"]={template="BMute"},
			["Button 1-8"]={template="BMute"},
	
			["Button 2-1"]={template="BSolo"},
			["Button 2-2"]={template="BSolo"},
			["Button 2-3"]={template="BSolo"},
			["Button 2-4"]={template="BSolo"},
			["Button 2-5"]={template="BSolo"},
			["Button 2-6"]={template="BSolo"},
			["Button 2-7"]={template="BSolo"},
			["Button 2-8"]={template="BSolo"},

			["Button 3-1"]={template="BMute"},
			["Button 3-2"]={template="BSolo"},
		},
		["Channel Faders"]={
		},
		["Master Compressor"]={
                        ["Button 1-2"]={template="BRedOnOff"},
                        ["Button 4-2"]={template="BRedOnOff"},
                        ["Fader 3"]={template="FOrange"},
                        ["UDVButton 1-4_2-4"]={template="FOrange"},
                        ["UDVButton 1-5_2-5"]={template="FYellow"},
                        ["UDVButton 1-6_2-6"]={template="FYellow"},
                        ["Fader 7"]={template="FRed"},
                        ["Meter 8"]={template="FRed"},
		},
		["Master Send"]={
                        ["Fader 1"]={template="FGreen"},
                        ["Fader 2"]={template="FGreen"},
                        ["Fader 3"]={template="FGreen"},
                        ["Fader 4"]={template="FGreen"},
                        ["Fader 5"]={template="FGreen"},
                        ["Fader 6"]={template="FGreen"},
                        ["Fader 7"]={template="FGreen"},
                        ["Fader 8"]={template="FGreen"},
		},
		["Master Insert"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 7-2"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
		},
		["Send Return *"]={
			["Button 1-2"]={template="BMute"},
                        ["Fader 3"]={template="FOrange"},
                        ["Knob V4"]={template="FOrange"},
                        ["Meter 8"]={template="FGreen"},
		},

	},
	["Mix Channel"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BAmpPage"},
                        ["Button B3"]={template="BEffectPage"},
                        ["Button B4"]={template="BEffectPage"},
                        ["Button B5"]={template="BFilterPage"},
                        ["Button B6"]={template="BEffectPage"},
                        ["Button B7"]={template="BEffectPage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Button 1-1"]={template="BMute"},
			["Button 1-2"]={template="BSolo"},
			["Fader 4"]={template="FEffect"},
			["Knob V5"]={template="FPan"},
			["BigFader 6"]={template="FVol"},
		},
		["Index"]={
			["Button 1-8"]={template="BAmpPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BFilterModPage"},
			["Button 5-8"]={template="BFilterModPage"},
			["Button 6-8"]={template="BFilterPage"},
			["Button 7-7"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			["Button 8-8"]={template="BEffect2Page"},
		},
		["Input"]={
			["Knob V2"]={template="FVol"},
			["Button 1-3"]={template="BMixOnOff"},
			["Button 1-4"]={template="BMixOnOff"},
			["Button 1-5"]={template="BMixOnOff"},
			["Button 1-7"]={template="BMixOnOff"},
		},
		["Compressor"]={
			["Button 1-2"]={template="BMixOnOff"},
			["Button 4-2"]={template="BMixOnOff"},
			["Fader 3"]={template="FMixComp"},
			["Fader 4"]={template="FMixComp"},
			["Fader 5"]={template="FMixComp"},
			["Button 1-6"]={template="BMixOnOff"},
			["Meter 8"]={template="FYellow"},
		},
		["Gate"]={
			["Button 1-2"]={template="BMixOnOff"},
			["Button 4-2"]={template="BMixOnOff"},
			["Fader 3"]={template="FMixGate"},
			["Fader 4"]={template="FMixGate"},
			["Fader 5"]={template="FMixGate"},
			["Fader 6"]={template="FMixGate"},
			["Button 1-7"]={template="BMixOnOff"},
			["Meter 8"]={template="FGreen"},
		},
		["Filter"]={
			["Button 1-2"]={template="BMixOnOff"},
			["Fader 3"]={template="FMixFilter"},
			["Button 1-4"]={template="BMixOnOff"},
			["Fader 5"]={template="FMixFilter"},
			["Button 1-7"]={template="BMixOnOff"},
		},
		["Equalizer High"]={
			["Button 1-1"]={template="BMixOnOff"},
			["Button 4-1"]={template="BMixOnOff"},
			["Knob V3"]={template="FMixEqHMF"},
			["Fader 4"]={template="FMixEqHMF"},
			["Fader 5"]={template="FMixEqHMF"},
			["Button 1-6"]={template="BMixOnOff"},
			["Knob V7"]={template="FMixEqHF"},
			["Fader 8"]={template="FMixEqHF"},
		},
		["Equalizer Low"]={
			["Button 1-1"]={template="BMixOnOff"},
			["Button 4-1"]={template="BMixOnOff"},
			["Button 1-2"]={template="BMixOnOff"},
			["Knob V3"]={template="FMixEqLF"},
			["Fader 4"]={template="FMixEqLF"},
			["Knob V6"]={template="FMixEqLMF"},
			["Fader 7"]={template="FMixEqLMF"},
			["Fader 8"]={template="FMixEqLMF"},
		},
		["Insert"]={
			["Button 1-2"]={template="BMixOnOff"},
			["Button 5-2"]={template="BMixOnOff"},
			["Button 6-2"]={template="BMixOnOff"},
			["Button 7-2"]={template="BMixOnOff"},
			["Button 8-2"]={template="BMixOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
                        ["Button A3"]={template="BBlueOnOff"},
                        ["Button A4"]={template="BBlueOnOff"},
                        ["Button A5"]={template="BBlueOnOff"},
                        ["Button A6"]={template="BBlueOnOff"},
		},
		["Send 1"]={
			["Fader 1"]={template="FEffect"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
                        ["Button A1"]={template="BBlueOnOff"},
                        ["Button A2"]={template="BBlueOnOff"},
                        ["Button A3"]={template="BBlueOnOff"},
                        ["Button A4"]={template="BBlueOnOff"},
                        ["Button A5"]={template="BBlueOnOff"},
                        ["Button A6"]={template="BBlueOnOff"},
                        ["Button A7"]={template="BBlueOnOff"},
                        ["Button A8"]={template="BBlueOnOff"},
		},
		["Send 2"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 1-2"]={template="BGreenOnOff"},
			["Button 1-3"]={template="BGreenOnOff"},
			["Button 1-4"]={template="BGreenOnOff"},
			["Button 1-5"]={template="BGreenOnOff"},
			["Button 1-6"]={template="BGreenOnOff"},
			["Button 1-7"]={template="BGreenOnOff"},
			["Button 1-8"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BMixOnOff"},
			["Button 2-2"]={template="BMixOnOff"},
			["Button 2-3"]={template="BMixOnOff"},
			["Button 2-4"]={template="BMixOnOff"},
			["Button 2-5"]={template="BMixOnOff"},
			["Button 2-6"]={template="BMixOnOff"},
			["Button 2-7"]={template="BMixOnOff"},
			["Button 2-8"]={template="BMixOnOff"},
                        ["Button A1"]={template="BBlueOnOff"},
                        ["Button A2"]={template="BBlueOnOff"},
                        ["Button A3"]={template="BBlueOnOff"},
                        ["Button A4"]={template="BBlueOnOff"},
                        ["Button A5"]={template="BBlueOnOff"},
                        ["Button A6"]={template="BBlueOnOff"},
                        ["Button A7"]={template="BBlueOnOff"},
                        ["Button A8"]={template="BBlueOnOff"},
		},
	},

	["Combinator"]={
		["Default"]={
		},
		["Main"]={
			-- On/Off/Bypass
			["UDVButton 1-1_2-1"]={template="UDGain"},
			-- Run
			["Button 5-1"]={template="BRedOnOff"},
			-- Bypass All Effects
			["Button 6-1"]={template="BRedOnOff"},
			-- Buttons
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			-- Rotaries
			["Fader 5"]={template="FMisc"},
			["Fader 6"]={template="FMisc"},
			["Fader 7"]={template="FMisc"},
			["Fader 8"]={template="FMisc"},
		},
	},
	["Antidote"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BAmpPage"},
                        ["Button B5"]={template="BFilterPage"},
                        ["Button B6"]={template="BLFOPage"},
                        ["Button B7"]={template="BPerformancePage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Index"]={
			["Button 8-1"]={template="BPerformancePage"},
			["Button 8-2"]={template="BPerformancePage"},
			["Button 8-3"]={template="BPerformancePage"},
			["Button 8-4"]={template="BPerformancePage"},
			["Button 8-5"]={template="BPerformancePage"},
		},
		["Main"]={
			["Fader 8"]={template="FVol"},
		},
		["Perf"]={
			["UDVButton 7-2_8-2"]={template="UDOsc"},
			["Fader 3"]={template="FPerf"},
		},
		["Osc *"]={
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true},
			["UDVButton 1-3_2-3"]={template="UDOsc"},
			["UDVButton 1-4_2-4"]={template="UDOsc"},
			["Fader 5"]={template="FOsc"},
			["Fader 6"]={template="FOsc"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
		},
		["OscMod *"]={
			["UDVButton 1-2_2-2"]={template="UDFreq"},
			["UDVButton 1-3_2-3"]={template="UDFreq"},
			["UDVButton 1-4_2-4"]={template="UDFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FPerf"},
			["Knob V8"]={template="FVol"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
		},
		["Mixer"]={
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FGain"},
			["Fader 5"]={template="FGain"},
			["Fader 6"]={template="FMisc"},
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpPage"},
		},
		["Filter"]={
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FEnv"},
			["Fader 8"]={template="FPerf"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterModPage"},
		},
		["Filter Envelope"]={
			["Fader 2"]={template="FEnv"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FFreq"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterModPage"},
		},
		["Effects"]={
			["Button 8-1"]={template="BGreenOnOff"},
			["Button 8-2"]={template="BGreenOnOff"},
			["Button 8-3"]={template="BGreenOnOff"},
			["Button 8-4"]={template="BGreenOnOff"},
			["Button 8-5"]={template="BGreenOnOff"},
			["Button 8-6"]={template="BGreenOnOff"},
			["Button 8-7"]={template="BGreenOnOff"},
			["Fader 8"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["EQ/Bass"]={ --EQBass
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDFreq"},
			["UDVButton 5-1_6-1"]={template="UDEffect"},
			["Fader 2"]={template="FGain"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FGain"},
			["Fader 6"]={template="FGain"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Dist"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect"},
			["UDVButton 5-1_6-1"]={template="UDEffect"},
			["Fader 2"]={template="FAmount"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FAmount"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Phaser"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect"},
			["UDVButton 5-1_6-1"]={template="UDFreq"},
			["Fader 2"]={template="FFreq"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FLFO"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Chorus"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["Fader 2"]={template="FFreq"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Delay"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect"},
			["UDVButton 5-1_6-1"]={template="UDFreq"},
			["UDVButton 7-1_8-1"]={template="UDFreq"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FLFO"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Reverb"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FLFO"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Comp"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["UDVButton 3-1_4-1"]={template="UDEffect"},
			["Fader 2"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["LFO *"]={
			["Button 1-1"]={template="BBRedOnOff"},
			["Button 1-3"]={template="BBBlueOnOff"},
                        ["UDVButton 3-1_4-1"]={template="UDLFO", inverted=true},
                        ["UDVButton 7-1_8-1"]={template="UDLFO", inverted=true},
                        ["Fader 4"]={template="FFreq"},
                        ["UDVButton 7-4_8-4"]={template="UDFreq"},
                        ["Knob V5"]={template="FLFO"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A3"]={template="BEnvPage"},
		},
		["Amp Env"]={
                        ["Fader 3"]={template="FVol"},
                        ["Fader 4"]={template="FVol"},
                        ["Fader 5"]={template="FVol"},
                        ["Fader 6"]={template="FVol"},
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpPage"},
		},
		["Mod Env"]={
                        ["UDVButton 3-1_4-1"]={template="UDEnv", inverted=true},
                        ["Fader 3"]={template="FEnv"},
                        ["Fader 4"]={template="FEnv"},
                        ["Fader 5"]={template="FEnv"},
                        ["Fader 6"]={template="FEnv"},
                        ["Knob V8"]={template="FEnv"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A3"]={template="BEnvPage"},
		},
		["Arpeggiator"]={
                        ["UDHButton 3-1_3-2"]={template="UDPerf"},
                        ["UDHButton 5-1_5-2"]={template="UDPerf"},
                        ["UDHButton 6-1_6-2"]={template="UDFreq"},
                        ["UDHButton 7-1_7-2"]={template="UDFreq"},
                        ["Knob V4"]={template="FPerf"},
                        ["Button 8-1"]={template="BGreenOnOff"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
                        ["Button A6"]={template="BPerformancePage"},
                        ["Button A7"]={template="BPerformancePage"},
		},
		["Mod Matrix *"]={
			["Button 1-1"]={template="BPerformancePage"},
			["Button 2-1"]={template="BPerformancePage"},
			["Button 3-1"]={template="BPerformancePage"},
			["Button 4-1"]={template="BPerformancePage"},
			["Button 5-1"]={template="BPerformancePage"},
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true},
			["Knob V3"]={template="FAmount"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
                        ["Button A6"]={template="BPerformancePage"},
                        ["Button A7"]={template="BPerformancePage"},
		},
	},
	["DrOctoRex"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BAmpPage"},
                        ["Button B4"]={template="BFilterPage"},
                        ["Button B5"]={template="BFilterModPage"},
                        ["Button B6"]={template="BLFOPage"},
                        ["Button B7"]={template="BPerformancePage"},
                        ["Button B8"]={template="BPerformancePage"},
		},
		["Main"]={
			["UDVButton 1-2_2-2"]={template="UDPerf"},
			["UDVButton 1-3_2-3"]={template="UDPerf"},
			-- Select Loop
			["Button 4-3"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BYellowOnOff"},
			["Button 4-5"]={template="BYellowOnOff"},
			["Button 4-6"]={template="BYellowOnOff"},
			["Button 5-3"]={template="BYellowOnOff"},
			["Button 5-4"]={template="BYellowOnOff"},
			["Button 5-5"]={template="BYellowOnOff"},
			["Button 5-6"]={template="BYellowOnOff"},
			-- Right Controls
			["Button 1-7"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRun"},
			["UDVButton 7-7_8-7"]={template="FFreq"},
			["Fader 8"]={template="FVol"},
		},
		["AmpEnv"]={
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Osc"]={
			["Knob V2"]={template="FOsc"},
			["UDVButton 1-3_2-3"]={template="UDFreq"},
			["UDVButton 1-4_2-4"]={template="UDFreq"},
		},
		["Loop"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDPerf"},
			["UDVButton 1-4_2-4"]={template="UDFreq"},
			["Fader 8"]={template="FVol"},
		},
		["Performance"]={
			["UDVButton 3-1_4-1"]={template="UDPerf"},
			["UDVButton 7-1_8-1"]={template="UDPerf"},
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FEffect"},
			["Knob V4"]={template="FEffect"},
			["Knob V6"]={template="FFreq"},
			["Knob V7"]={template="FEffect"},
			["Knob V8"]={template="FVol"},
		},
		["Filter"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="FFreq", inverted=true},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
		},
		["FilterEnv"]={
			["Fader 2"]={template="FEnv"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FFreq"},
		},
		["LFO"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", inverted=true},
			["UDVButton 5-2_6-2"]={template="UDLFO", inverted=true},
			["Button 1-4"]={template="BRedOnOff"},
			["Fader 5"]={template="FFreq"},
			["UDVButton 7-5_8-5"]={template="UDFreq"},
			["Fader 8"]={template="FLFO"},
		},
	},
	["Europa"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BOscPage"},
                        ["Button B5"]={template="BAmpPage"},
                        ["Button B6"]={template="BFilterPage"},
                        ["Button B7"]={template="BLFOPage"},
                        ["Button B8"]={template="BEffectPage"},

		},
		["Main"]={
			["Fader 8"]={template="FGain"},
		},
		["Perf"]={
			["UDVButton 7-1_8-1"]={template="UDPerf2"},
			["UDVButton 7-3_8-3"]={template="UDPerf"},
			["Fader 4"]={template="FPerf"},
			["UDVButton 7-6_8-6"]={template="UDPerf"},
			["UDVButton 7-8_8-8"]={template="UDOsc"},
		},
		["Index"]={
			["Button 7-1"]={template="BPerformancePage"},
			["Button 7-2"]={template="BPerformancePage"},
			["Button 7-3"]={template="BPerformancePage"},
			["Button 7-4"]={template="BPerformancePage"},
			["Button 8-1"]={template="BPerformancePage"},
			["Button 8-2"]={template="BPerformancePage"},
			["Button 8-3"]={template="BPerformancePage"},
			["Button 8-4"]={template="BPerformancePage"},
			["Button 5-5"]={template="BFilterPage"},
			["Button 2-7"]={template="BEffect2Page"},
			["Button 3-7"]={template="BEffect2Page"},
			["Button 4-7"]={template="BEffect2Page"},
		},
		["Mixer"]={
			["Fader 2"]={template="FVol"},
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Knob V6"]={template="FPan"},
			["Knob V7"]={template="FPan"},
			["Knob V8"]={template="FPan"},
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpPage"},
		},
		["Filter"]={
			["Button 5-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Button 7-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FGain"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FFreq"},
			["UDVButton 1-6_2-6"]={template="UDPerf"},
			["UDVButton 3-6_4-6"]={template="UDLFO"},
			["UDVButton 5-6_6-6"]={template="UDPerf"},
			["UDVButton 3-7_4-7"]={template="UDLFO", inverted=true},
		},
		["Amp"]={
			["Knob V2"]={template="FPan"},
			["Fader 3"]={template="FGain"},
			["Fader 4"]={template="FPerf"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
			["Fader 8"]={template="FVol"},
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpPage"},
		},
		["Eng *"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDFreq"},
			["UDVButton 3-3_4-3"]={template="UDFreq2"},
			["UDVButton 5-3_6-3"]={template="UDFreq"},
			["UDVButton 7-3_8-3"]={template="UDPerf"},
			["UDVButton 1-4_2-4"]={template="UDOsc", inverted=true},
			["Button 8-4"]={template="BRedOnOff"},
			["Fader 5"]={template="FOsc"},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true},
			["Fader 7"]={template="FLFO"},
			["Fader 8"]={template="FPerf"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A5"]={template="BFilterPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Eng * Mod *"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true},
			["Fader 4"]={template="FOsc"},
			["Fader 5"]={template="FLFO"},
			["UDVButton 7-6_8-6"]={template="UDLFO", inverted=true},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A5"]={template="BFilterPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Eng * Spectral Filter"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 3-2_4-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FPerf"},
			["Fader 6"]={template="FLFO"},
			["UDVButton 7-7_8-7"]={template="UDLFO", inverted=true},
			["Fader 8"]={template="FPerf"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A5"]={template="BFilterPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Eng * Harmonics"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDOsc", inverted=true},
			["Fader 4"]={template="FOsc"},
			["Fader 5"]={template="FOsc"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A5"]={template="BFilterPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
		["Eng * Unison"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDEffect", inverted=true},
			["UDVButton 1-4_2-4"]={template="UDEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A5"]={template="BFilterPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BEffectPage"},
		},
                ["Env *"]={
                        ["Fader 3"]={template="FFreq"},
                        ["UDVButton 7-4_8-4"]={template="UDFreq"},
                        ["Button A1"]={template="BEnvPage"},
                        ["Button A2"]={template="BEnvPage"},
                        ["Button A3"]={template="BEnvPage"},
                        ["Button A4"]={template="BEnvPage"},
                        ["Button A6"]={template="BLFOPage"},
                        ["Button A7"]={template="BLFOPage"},
                        ["Button A8"]={template="BLFOPage"},
                },
                ["LFO *"]={
                        ["Button 5-1"]={template="BLFOPage", helptext="Goto LFO 1"},
                        ["Button 6-1"]={template="BLFOPage", helptext="Goto LFO 2"},
                        ["Button 7-1"]={template="BLFOPage", helptext="Goto LFO 3"},
                        ["UDVButton 1-2_2-2"]={template="UDLFO"},
                        ["Button 6-2"]={template="BRedOnOff"},
                        ["Button 7-2"]={template="BRedOnOff"},
                        ["Button 8-2"]={template="BRedOnOff"},
                        ["Fader 3"]={template="FFreq"},
                        ["UDVButton 7-3_8-3"]={template="UDFreq"},
                        ["Fader 4"]={template="FEffect"},
                        ["Button A1"]={template="BEnvPage"},
                        ["Button A2"]={template="BEnvPage"},
                        ["Button A3"]={template="BEnvPage"},
                        ["Button A4"]={template="BEnvPage"},
                        ["Button A6"]={template="BLFOPage"},
                        ["Button A7"]={template="BLFOPage"},
                        ["Button A8"]={template="BLFOPage"},
                },
		["Effects"]={
			-- Mini
			["Button 2-7"]={template="BRedOnOff"},
			["Button 3-7"]={template="BRedOnOff"},
			["Button 4-7"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRedOnOff"},
			["Button 6-7"]={template="BRedOnOff"},
			["Button 7-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Button 8-6"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
		},
		["Phaser"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["UDVButton 5-1_6-1"]={template="UDEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Dist"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["UDVButton 5-1_6-1"]={template="UDEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
		},
		["Eq"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FAmount"},
		},
		["Delay"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["Button 4-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Comp"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Reverb"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["Fader 2"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
                ["Mod Matrix *"]={
                        ["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true},
                        ["Knob V3"]={template="FAmount"},
                        ["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true},
                        ["Knob V5"]={template="FEffect"},
                        ["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true},
                        ["Knob V7"]={template="FEffect"},
                        ["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
                        ["Button A6"]={template="BPerformancePage"},
                        ["Button A7"]={template="BPerformancePage"},
                        ["Button A8"]={template="BPerformancePage"},
                },
	},
	["Grain"]={
		["Default"]={
			["Button 1-2"]={template="BRedOnOff"},
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BAmpPage"},
                        ["Button B5"]={template="BFilterPage"},
                        ["Button B6"]={template="BLFOPage"},
                        ["Button B7"]={template="BPerformancePage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Fader 8"]={template="FGain"},
		},
		["Perf"]={
                        ["UDVButton 7-1_8-1"]={template="UDPerf2"},
                        ["UDVButton 7-3_8-3"]={template="UDPerf"},
                        ["Fader 4"]={template="FPerf"},
                        ["UDVButton 7-6_8-6"]={template="UDPerf"},
                        ["UDVButton 7-8_8-8"]={template="UDOsc"},
		},
		["Index"]={
			["Button 1-2"]={template="BAmpPage"},
			["Button 7-1"]={template="BPerformancePage"},
			["Button 7-2"]={template="BPerformancePage"},
			["Button 7-3"]={template="BPerformancePage"},
			["Button 7-4"]={template="BPerformancePage"},
			["Button 8-1"]={template="BPerformancePage"},
			["Button 8-2"]={template="BPerformancePage"},
			["Button 8-3"]={template="BPerformancePage"},
			["Button 8-4"]={template="BPerformancePage"},
		},
		["Sample"]={
			["Fader 1"]={template="FMisc"},
			["Fader 2"]={template="FMisc"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FGain"},
			["UDVButton 1-5_2-5"]={template="UDOsc", inverted=true},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FOsc"},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Grains"]={
			["UDVButton 1-1_2-1"]={template="UDOsc", inverted=true},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A5"]={template="BOscPage"},
			["Spectral Grains"]={
				["Fader 2"]={template="FOsc"},
				["Fader 3"]={template="FFreq"},
				["Button 1-4"]={template="BRedOnOff"},
				["UDVButton 7-4_8-4"]={template="UDOsc"},
				["Fader 5"]={template="FOsc"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FPerf"},
			},
			["Grain Oscillator"]={
				["Fader 2"]={template="FOsc"},
				["Fader 3"]={template="FOsc"},
				["Fader 4"]={template="FFreq"},
				["Fader 5"]={template="FOsc"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FPerf"},
			},
			["Long Grains"]={
				["Fader 2"]={template="FOsc"},
				["Fader 3"]={template="FOsc"},
				["Fader 5"]={template="FOsc"},
				["Fader 6"]={template="FFreq"},
				["Fader 7"]={template="FOsc"},
			},
			["Tape"]={
				["Fader 6"]={template="FOsc"},
			},
		},
		["Pitch"]={
			["UDVButton 1-2_2-2"]={template="UDFreq"},
			["UDVButton 1-3_2-3"]={template="UDFreq"},
			["UDVButton 1-4_2-4"]={template="UDFreq"},
			["Fader 6"]={template="FPerf"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A5"]={template="BOscPage"},
		},
		["Osc"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 1-3_2-3"]={template="UDFreq"},
			["UDVButton 1-4_2-4"]={template="UDOsc"},
			["Fader 6"]={template="FOsc"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A5"]={template="BOscPage"},
		},
		["Mixer"]={
			["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true},
			["Fader 3"]={template="FVol"},
			["UDVButton 1-5_2-5"]={template="UDAmount"},
			["Fader 6"]={template="FVol"},
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpPage"},
		},
		["Filter"]={
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FEnv"},
			["Fader 7"]={template="FPerf"},
			["Fader 8"]={template="FPerf"},
		},
		["Amp"]={
			["Fader 2"]={template="FGain"},
			["Fader 3"]={template="FGain"},
			["Fader 4"]={template="FGain"},
			["Fader 5"]={template="FGain"},
			["Fader 6"]={template="FAmount"},
			["Fader 7"]={template="FMisc"},
			["Knob V8"]={template="FGain"},
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpPage"},
		},
                ["Env *"]={
                        ["Fader 3"]={template="FFreq"},
                        ["UDVButton 7-4_8-4"]={template="UDFreq"},
                        ["Button A1"]={template="BEnvPage"},
                        ["Button A2"]={template="BEnvPage"},
                        ["Button A3"]={template="BEnvPage"},
                        ["Button A4"]={template="BEnvPage"},
                        ["Button A6"]={template="BLFOPage"},
                        ["Button A7"]={template="BLFOPage"},
                        ["Button A8"]={template="BLFOPage"},
                },
                ["LFO *"]={
                        ["Button 5-1"]={template="BLFOPage", helptext="Goto LFO 1"},
                        ["Button 6-1"]={template="BLFOPage", helptext="Goto LFO 2"},
                        ["Button 7-1"]={template="BLFOPage", helptext="Goto LFO 3"},
                        ["UDVButton 1-2_2-2"]={template="UDLFO"},
                        ["Button 6-2"]={template="BRedOnOff"},
                        ["Button 7-2"]={template="BRedOnOff"},
                        ["Button 8-2"]={template="BRedOnOff"},
                        ["Fader 3"]={template="FFreq"},
                        ["UDVButton 7-3_8-3"]={template="UDFreq"},
                        ["Fader 4"]={template="FEffect"},
                        ["Button A1"]={template="BEnvPage"},
                        ["Button A2"]={template="BEnvPage"},
                        ["Button A3"]={template="BEnvPage"},
                        ["Button A4"]={template="BEnvPage"},
                        ["Button A6"]={template="BLFOPage"},
                        ["Button A7"]={template="BLFOPage"},
                        ["Button A8"]={template="BLFOPage"},
                },
		["Effects"]={
			-- Mini
			["Button 2-7"]={template="BRedOnOff"},
			["Button 3-7"]={template="BRedOnOff"},
			["Button 4-7"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRedOnOff"},
			["Button 6-7"]={template="BRedOnOff"},
			["Button 7-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Button 8-6"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
		},
		["Phaser"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["UDVButton 5-1_6-1"]={template="UDEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Dist"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["UDVButton 5-1_6-1"]={template="UDEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
		},
		["Eq"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FAmount"},
		},
		["Delay"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["Button 4-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Comp"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Reverb"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-8"]={template="BMainEffectPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 5-8"]={template="BEffectPage"},
			["Button 6-8"]={template="BEffectPage"},
			["Button 7-8"]={template="BEffectPage"},
			-- Pro
			["Button 1-1"]={template="BRedOnOff"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			-- Common
			["Fader 2"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
                ["Mod Matrix *"]={
                        ["UDVButton 1-2_2-2"]={template="UDAmount", inverted=true},
                        ["Knob V3"]={template="FAmount"},
                        ["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true},
                        ["Knob V5"]={template="FEffect"},
                        ["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true},
                        ["Knob V7"]={template="FEffect"},
                        ["UDVButton 1-8_2-8"]={template="UDMisc", inverted=true},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
                        ["Button A6"]={template="BPerformancePage"},
                        ["Button A7"]={template="BPerformancePage"},
                        ["Button A8"]={template="BPerformancePage"},
                },
	},
	["Humana"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BFilterModPage"},
                        ["Button B5"]={template="BAmpPage"},
                        ["Button B6"]={template="BPerformancePage"},
                        ["Button B7"]={template="BEffectPage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Fader 8"]={template="FVol"},
		},
		["Perf"]={
			["UDVButton 7-1_8-1"]={template="UDPerf"},
			["Fader 2"]={template="FOsc"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FVol"},
		},
		["Instrument"]={
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true},
			["Fader 4"]={template="FOsc"},
			["UDVButton 1-5_2-5"]={template="UDFreq"},
			["UDVButton 1-6_2-6"]={template="UDFreq"},
			["UDVButton 1-7_2-7"]={template="UDFreq"},
		},
		["Amp"]={
			["Fader 2"]={template="FPerf"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Filter"]={
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEnv"},
			["Fader 7"]={template="FPerf"},
			["Fader 8"]={template="FPerf"},
		},
		["Filter Envelope"]={
			["Fader 2"]={template="FEnv"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FFreq"},
		},
		["Delay"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect"},
			["Button 1-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Reverb"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 8"]={template="FEffect"},
		},
	},
	["ID8"]={
		["Default"]={
		},
		["Main"]={
			["Button 1-1"]={template="BSelCat"},
			["Button 2-1"]={template="BSelCat"},
			["Button 1-4"]={template="BSelSound"},
			["Button 2-4"]={template="BSelSound"},
			["Button 3-4"]={template="BSelSound"},
			["Button 4-4"]={template="BSelSound"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FVol"},
		},
	},
	["Klang"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BFilterModPage"},
                        ["Button B5"]={template="BAmpPage"},
                        ["Button B6"]={template="BPerformancePage"},
                        ["Button B7"]={template="BEffectPage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Fader 8"]={template="FVol"},
		},
		["Perf"]={
			["UDVButton 7-1_8-1"]={template="UDPerf"},
			["Fader 2"]={template="FOsc"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FVol"},
		},
		["Instrument"]={
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true},
			["Fader 4"]={template="FOsc"},
			["UDVButton 1-5_2-5"]={template="UDFreq"},
			["UDVButton 1-6_2-6"]={template="UDFreq"},
			["UDVButton 1-7_2-7"]={template="UDFreq"},
		},
		["Amp"]={
			["Fader 2"]={template="FPerf"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Filter"]={
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEnv"},
			["Fader 7"]={template="FPerf"},
			["Fader 8"]={template="FPerf"},
		},
		["Filter Envelope"]={
			["Fader 2"]={template="FEnv"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FFreq"},
		},
		["Delay"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect"},
			["Button 1-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Reverb"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 8"]={template="FEffect"},
		},
	},
	["Kong"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BPerformancePage"},
                        ["Button B5"]={template="BPerformancePage"},
                        ["Button B6"]={template="BAmpPage"},
                        ["Button B7"]={template="BEffectPage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Index"]={
			-- Pads
			["Button 5-1"]={template="BOscPage"},
			["Button 5-2"]={template="BOscPage"},
			["Button 5-3"]={template="BOscPage"},
			["Button 5-4"]={template="BOscPage"},
			["Button 6-1"]={template="BOscPage"},
			["Button 6-2"]={template="BOscPage"},
			["Button 6-3"]={template="BOscPage"},
			["Button 6-4"]={template="BOscPage"},
			["Button 7-1"]={template="BOscPage"},
			["Button 7-2"]={template="BOscPage"},
			["Button 7-3"]={template="BOscPage"},
			["Button 7-4"]={template="BOscPage"},
			["Button 8-1"]={template="BOscPage"},
			["Button 8-2"]={template="BOscPage"},
			["Button 8-3"]={template="BOscPage"},
			["Button 8-4"]={template="BOscPage"},
			-- Pads
			["Button 5-5"]={template="BPerformancePage"},
			["Button 5-6"]={template="BPerformancePage"},
			["Button 5-7"]={template="BPerformancePage"},
			["Button 5-8"]={template="BPerformancePage"},
			["Button 6-5"]={template="BPerformancePage"},
			["Button 6-6"]={template="BPerformancePage"},
			["Button 6-7"]={template="BPerformancePage"},
			["Button 6-8"]={template="BPerformancePage"},
			["Button 7-5"]={template="BPerformancePage"},
			["Button 7-6"]={template="BPerformancePage"},
			["Button 7-7"]={template="BPerformancePage"},
			["Button 7-8"]={template="BPerformancePage"},
			["Button 8-5"]={template="BPerformancePage"},
			["Button 8-6"]={template="BPerformancePage"},
			["Button 8-7"]={template="BPerformancePage"},
			["Button 8-8"]={template="BPerformancePage"},
		},
		["Main"]={
			-- Pads
			["Button 5-1"]={template="BPad"},
			["Button 5-2"]={template="BPad"},
			["Button 5-3"]={template="BPad"},
			["Button 5-4"]={template="BPad"},
			["Button 6-1"]={template="BPad"},
			["Button 6-2"]={template="BPad"},
			["Button 6-3"]={template="BPad"},
			["Button 6-4"]={template="BPad"},
			["Button 7-1"]={template="BPad"},
			["Button 7-2"]={template="BPad"},
			["Button 7-3"]={template="BPad"},
			["Button 7-4"]={template="BPad"},
			["Button 8-1"]={template="BPad"},
			["Button 8-2"]={template="BPad"},
			["Button 8-3"]={template="BPad"},
			["Button 8-4"]={template="BPad"},
			["Fader 6"]={template="FVol"},
		},
		["Mutes & Solos"]={
			-- Mute
			["Button 1-1"]={template="BMute"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BMute"},
			["Button 1-4"]={template="BMute"},
			["Button 2-1"]={template="BMute"},
			["Button 2-2"]={template="BMute"},
			["Button 2-3"]={template="BMute"},
			["Button 2-4"]={template="BMute"},
			["Button 3-1"]={template="BMute"},
			["Button 3-2"]={template="BMute"},
			["Button 3-3"]={template="BMute"},
			["Button 3-4"]={template="BMute"},
			["Button 4-1"]={template="BMute"},
			["Button 4-2"]={template="BMute"},
			["Button 4-3"]={template="BMute"},
			["Button 4-4"]={template="BMute"},
			-- Solo
			["Button 1-5"]={template="BSolo"},
			["Button 1-6"]={template="BSolo"},
			["Button 1-7"]={template="BSolo"},
			["Button 1-8"]={template="BSolo"},
			["Button 2-5"]={template="BSolo"},
			["Button 2-6"]={template="BSolo"},
			["Button 2-7"]={template="BSolo"},
			["Button 2-8"]={template="BSolo"},
			["Button 3-5"]={template="BSolo"},
			["Button 3-6"]={template="BSolo"},
			["Button 3-7"]={template="BSolo"},
			["Button 3-8"]={template="BSolo"},
			["Button 4-5"]={template="BSolo"},
			["Button 4-6"]={template="BSolo"},
			["Button 4-7"]={template="BSolo"},
			["Button 4-8"]={template="BSolo"},
		},
		["Drum *"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscPage"},
                        ["Button A3"]={template="BOscPage"},
                        ["Button A4"]={template="BOscPage"},
                        ["Button A5"]={template="BOscPage"},
                        ["Button A6"]={template="BOscPage"},
                        ["Button A7"]={template="BOscPage"},
                        ["Button A8"]={template="BOscPage"},
			-- SubPages
			["Button 1-1"]={template="BOscPage"},
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BEffectPage"},
			["Button 4-1"]={template="BEffectPage"},
			["DrumMain"]={
				-- Offset
				["UDVButton 1-2_2-2"]={template="UDOsc"},
				["UDVButton 3-2_4-2"]={template="UDFreq"},
				-- Sends
				["UDVButton 1-3_2-3"]={template="UDEffect"},
				["UDVButton 3-3_4-3"]={template="UDEffect"},
				["UDVButton 3-4_4-4"]={template="UDEffect"},
				["Knob V5"]={template="FOsc"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
				-- Outputs
				["UDVButton 5-8_6-8"]={template="UDVol"},
				-- Pitch Bend Range
				["UDVButton 7-8_8-8"]={template="UDPerf"},
			},
			["DrumModule"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Fader 5"]={template="FFreq"},
				["Knob V6"]={template="FOsc"},
				["Fader 7"]={template="FOsc"},
				["Fader 8"]={template="FVol"},
			},
			["DrumFX1"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
			["DrumFX2"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Button 1-4"]={template="BYellowOnOff"},
				["Button 2-4"]={template="BYellowOnOff"},
				["Button 3-4"]={template="BYellowOnOff"},
				["Button 4-4"]={template="BYellowOnOff"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Pad *"]={
			["UDVButton 1-2_2-2"]={template="UDOsc"},
			["UDVButton 3-2_4-2"]={template="UDPerf", inverted=true},
			-- Pad Groups
			["Button 1-6"]={template="BYellowOnOff"},
			["Button 1-7"]={template="BYellowOnOff"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-6"]={template="BYellowOnOff"},
			["Button 2-7"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["Button 3-6"]={template="BYellowOnOff"},
			["Button 3-7"]={template="BYellowOnOff"},
			["Button 3-8"]={template="BYellowOnOff"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
                        ["Button A6"]={template="BPerformancePage"},
                        ["Button A7"]={template="BPerformancePage"},
                        ["Button A8"]={template="BPerformancePage"},
		},
		["Bus FX"]={
			["Button 1-2"]={template="BYellowOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FVol"},
		},
		["Master FX"]={
			["Button 1-2"]={template="BYellowOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
		},
	},
	["Malstrom"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BLFOPage"},
                        ["Button B7"]={template="BPerformancePage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FGain"},
		},
		["Perf"]={
			["UDVButton 7-2_8-2"]={template="FPerf"},
			["Button 8-3"]={template="BYellowOnOff"},
			["Fader 4"]={template="FPerf"},
			["UDVButton 7-5_8-5"]={template="FPerf"},
                        ["Button A1"]={template="BPerfPage"},
                        ["Button A2"]={template="BPerfPage"},
                        ["Button A3"]={template="BPerfPage"},
		},
		["Osc *"]={
			["Button 1-1"]={template="BYellowOnOff"},
			["Fader 2"]={template="FOsc"},
			["Fader 3"]={template="FOsc"},
			["Knob V4"]={template="FOsc"},
			["UDVButton 7-5_8-5"]={template="UDFreq"},
			["UDVButton 7-6_8-6"]={template="UDFreq"},
			["UDVButton 7-7_8-7"]={template="UDFreq"},
			["Button 8-8"]={template="BYellowOnOff"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A5"]={template="BOscPage"},
                        ["Button A6"]={template="BOscModPage"},
		},
		["Osc A"]={
			["Button 7-8"]={template="BYellowOnOff"},
		},
		["Osc * Env"]={
			["Fader 3"]={template="FOsc"},
			["Fader 4"]={template="FOsc"},
			["Fader 5"]={template="FOsc"},
			["Fader 6"]={template="FOsc"},
			["Fader 8"]={template="FVol"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A5"]={template="BOscPage"},
                        ["Button A6"]={template="BOscModPage"},
		},
		["Filter *"]={
			["Button 1-1"]={template="BYellowOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["Button 8-5"]={template="BYellowOnOff"},
			["Button 8-6"]={template="BYellowOnOff"},
			["Button 1-6"]={template="BYellowOnOff"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
		},
		["Filter Env"]={
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Button 8-7"]={template="BYellowOnOff"},
			["Fader 8"]={template="FEnv"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
		},
		["Mod *"]={
			["Button 1-1"]={template="BYellowOnOff"},
			["UDVButton 1-2_2-2"]={template="UDLFO"},
			["Fader 3"]={template="FFreq"},
			["Button 1-8"]={template="BYellowOnOff"},
			["Button 2-8"]={template="BYellowOnOff"},
			["UDVButton 7-8_8-8"]={template="UDLFO"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
		},
		["Mod A"]={
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FOsc"},
			["Knob V6"]={template="FOsc"},
		},
		["Mod B"]={
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FFreq"},
			["Knob V7"]={template="FLFO"},
		},
		["Shaper"]={
			["Button 1-2"]={template="BYellowOnOff"},
			["UDVButton 1-3_2-3"]={template="FEffect", inverted=true},
			["Fader 8"]={template="FEffect"},
		},
		["Velocity"]={
			["Knob V2"]={template="FOsc"},
			["Knob V3"]={template="FOsc"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FLFO"},
			["UDVButton 7-8_8-8"]={template="UDPerf"},
                        ["Button A1"]={template="BPerfPage"},
                        ["Button A2"]={template="BPerfPage"},
                        ["Button A3"]={template="BPerfPage"},
		},
		["ModWheel"]={
			["Knob V2"]={template="FOsc"},
			["Knob V3"]={template="FOsc"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FLFO"},
			["UDVButton 7-8_8-8"]={template="UDPerf"},
                        ["Button A1"]={template="BPerfPage"},
                        ["Button A2"]={template="BPerfPage"},
                        ["Button A3"]={template="BPerfPage"},
		},
	},
	["NN-19"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BAmpPage"},
                        ["Button B5"]={template="BLFOPage"},
                        ["Button B6"]={template="BPerformancePage"},
		},
		["Index"]={
			["Button 1-4"]={template="BPerformancePage"},
		},
		["Main"]={
			["Fader 8"]={template="FVol"},
		},
		["Perf"]={
			["Fader 1"]={template="FPerf"},
			["UDVButton 1-2_2-2"]={template="UDPerf"},
			["Fader 3"]={template="FEffect"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true},
			["Button 1-5"]={template="BRedOnOff"},
			["UDVButton 1-6_2-6"]={template="UDPerf", inverted=true},
			["UDVButton 1-7_2-7"]={template="UDPerf"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
		},
		["Amp"]={
			["Fader 1"]={template="FVol"},
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
		},
		["Controller"]={
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FLFO"},
			["Knob V4"]={template="FVol"},
			["UDVButton 1-5_2-5"]={template="UDPerf", inverted=true},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
		},
		["Mod Wheel"]={
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FEffect"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FLFO"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
		},
		["Velocity"]={
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FFreq"},
			["Knob V4"]={template="FVol"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FOsc"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
		},
		["Osc"]={
			["Fader 1"]={template="FOsc"},
			["Button 1-2"]={template="BRedOnOff"},
			["Knob V3"]={template="FEnv"},
			["UDVButton 1-5_2-5"]={template="UDFreq"},
			["UDVButton 1-6_2-6"]={template="UDFreq"},
			["UDVButton 1-7_2-7"]={template="UDFreq"},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Filter"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["UDVButton 1-5_2-5"]={template="UDFreq", inverted=true},
			["Fader 6"]={template="FPerf"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterModPage"},
		},
		["Filter Envelope"]={
			["Fader 2"]={template="FFreq"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Button 1-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FEnv"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterModPage"},
		},
		["LFO"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", inverted=true},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq"},
			["Fader 5"]={template="FLFO"},
			["UDVButton 1-6_2-6"]={template="UDLFO", inverted=true},
		},
	},
	["NN-XT"]={
		["Default"]={
			["Fader 1"]={template="FPerf"},
			["Knob V2"]={template="FFreq"},
			["Knob V3"]={template="FEffect"},
			["Knob V4"]={template="FVol"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FVol"},
			["Knob V7"]={template="FEnv"},
			["Fader 8"]={template="FVol"},
		},
	},
	["Pangea"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BFilterModPage"},
                        ["Button B5"]={template="BAmpPage"},
                        ["Button B6"]={template="BPerformancePage"},
                        ["Button B7"]={template="BEffectPage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Fader 8"]={template="FVol"},
		},
		["Perf"]={
			["UDVButton 7-1_8-1"]={template="UDPerf"},
			["Fader 2"]={template="FOsc"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FVol"},
		},
		["Instrument"]={
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true},
			["Fader 4"]={template="FOsc"},
			["UDVButton 1-5_2-5"]={template="UDFreq"},
			["UDVButton 1-6_2-6"]={template="UDFreq"},
			["UDVButton 1-7_2-7"]={template="UDFreq"},
		},
		["Amp"]={
			["Fader 2"]={template="FPerf"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Filter"]={
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEnv"},
			["Fader 7"]={template="FPerf"},
			["Fader 8"]={template="FPerf"},
		},
		["Filter Envelope"]={
			["Fader 2"]={template="FEnv"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FFreq"},
		},
		["Delay"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect"},
			["Button 1-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Reverb"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Fader 8"]={template="FEffect"},
		},
	},
	["Parsec"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BAmpPage"},
                        ["Button B5"]={template="BLFOPage"},
                        ["Button B6"]={template="BPerformancePage"},
                        ["Button B7"]={template="BEffectPage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Knob V6"]={template="FVol"},
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FVol"},
		},
		["Perf"]={
			["UDVButton 7-1_8-1"]={template="UDPerf"},
			["UDVButton 7-3_8-3"]={template="UDPerf"},
			["UDVButton 7-5_8-5"]={template="UDPerf"},
			["Fader 6"]={template="FPerf"},
		},
		["Index"]={
			["Button 8-1"]={template="BPerformancePage"},
			["Button 8-2"]={template="BPerformancePage"},
			["Button 8-3"]={template="BPerformancePage"},
			["Button 8-4"]={template="BPerformancePage"},
			["Button 8-5"]={template="BPerformancePage"},
			["Button 8-6"]={template="BPerformancePage"},
			["Button 8-7"]={template="BPerformancePage"},
			["Button 8-8"]={template="BPerformancePage"},
		},
		["Amp Envelope"]={
			["Fader 2"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Generator *"]={
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FOsc"},
			["UDVButton 1-4_2-4"]={template="UDFreq"},
			["UDVButton 3-4_4-4"]={template="UDFreq2"},
			["UDVButton 5-4_6-4"]={template="UDFreq"},
			["Fader 5"]={template="FPerf"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FFreq"},
			["Fader 8"]={template="FPerf"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscPage"},
		},
		["Sound Engine *"]={
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["UDVButton 1-5_2-5"]={template="UDEffect", inverted=true},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
		},
		["Reverb"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
		},
		["Delay"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
		},
		["LFO *"]={
			["UDVButton 1-2_2-2"]={template="UDLFO"},
			["Fader 3"]={template="FEffect"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A5"]={template="BEnvPage"},
                        ["Button A6"]={template="BEnvPage"},
		},
		["Env 1"]={
			["Fader 3"]={template="FEnv"},
			["Fader 4"]={template="FEnv"},
			["Fader 5"]={template="FEnv"},
			["Fader 6"]={template="FEnv"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A5"]={template="BEnvPage"},
                        ["Button A6"]={template="BEnvPage"},
		},
		["Env 2"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEnv"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEnv"},
			["Fader 7"]={template="FEnv"},
			["Fader 8"]={template="FEnv"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A5"]={template="BEnvPage"},
                        ["Button A6"]={template="BEnvPage"},
		},
		["Mod Matrix *"]={
			["Button 1-1"]={template="BPerformancePage"},
			["Button 2-1"]={template="BPerformancePage"},
			["Button 3-1"]={template="BPerformancePage"},
			["Button 4-1"]={template="BPerformancePage"},
			["Button 5-1"]={template="BPerformancePage"},
			["Button 6-1"]={template="BPerformancePage"},
			["Button 7-1"]={template="BPerformancePage"},
			["Button 8-1"]={template="BPerformancePage"},
			["UDVButton 1-2_2-2"]={template="UDLFO", inverted=true},
			["Knob V3"]={template="FLFO"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true},
			["Knob V5"]={template="FEffect"},
			["UDVButton 1-6_2-6"]={template="UDEffect", inverted=true},
			["Knob V7"]={template="FEffect"},
			["UDVButton 1-8_2-8"]={template="UDPerf", inverted=true},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
                        ["Button A6"]={template="BPerformancePage"},
                        ["Button A7"]={template="BPerformancePage"},
                        ["Button A8"]={template="BPerformancePage"},
		},
	},
	["PX7"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BOscPage"},
                        ["Button B5"]={template="BOscPage"},
                        ["Button B6"]={template="BOscPage"},
                        ["Button B7"]={template="BOscPage"},
                        ["Button B8"]={template="BLFOPage"},
		},
		["Main"]={
			["UDVButton 1-2_2-2"]={template="FOsc"},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FOsc"},
			["Knob V6"]={template="FVol"},
			["Knob V7"]={template="FVol"},
			["Fader 8"]={template="FVol"},
		},
		["Perf"]={
			["Fader 3"]={template="FPerf"},
		},
		["Op*"]={
			["Button 8-2"]={template="BGreenOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq"},
			["UDVButton 7-5_8-5"]={template="UDFreq"},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FGain"},
		},
		["LFO"]={
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["UDVButton 7-3_8-3"]={template="UDFreq"},
			["Fader 4"]={template="FMisc"},
			["UDVButton 1-5_2-5"]={template="UDMisc", inverted=true},
		},
	},
	["Radical Piano"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BOscPage"},
                        ["Button B6"]={template="BAmpPage"},
                        ["Button B7"]={template="BPerformancePage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Fader 2"]={template="FEffect"},
			["Fader 4"]={template="FOsc"},
			["UDVButton 7-5_8-5"]={template="UDOsc"},
			["Knob V6"]={template="FOsc"},
			["UDVButton 7-7_8-7"]={template="UDOsc"},
			["Fader 8"]={template="FVol"},
		},
		["Envelope"]={
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Fader 4"]={template="FVol"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FVol"},
		},
		["Velocity"]={
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Fader 4"]={template="FPerf"},
			["Fader 5"]={template="FPerf"},
			["Knob V6"]={template="FPerf"},
		},
		["Tune"]={
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Knob V4"]={template="FFreq"},
			["Fader 5"]={template="FOsc"},
		},
		["Resonance"]={
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FFreq"},
		},
		["Mechanics"]={
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FOsc"},
			["Knob V6"]={template="FOsc"},
		},
		["Eq"]={
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["Knob V4"]={template="FEffect"},
			["Knob V5"]={template="FEffect"},
			["Knob V6"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
		},
		["Ambience"]={
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
			["Fader 4"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
		},
		["Output"]={
			["Button 2-1"]={template="BOscPage"},
			["Button 3-1"]={template="BOscPage"},
			["Button 4-1"]={template="BOscPage"},
			["Button 2-8"]={template="BEffectPage"},
			["Button 3-8"]={template="BEffectPage"},
			["Button 4-8"]={template="BEffectPage"},
			["Fader 3"]={template="FEffect"},
			["Knob V4"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
		},
	},
	["Redrum"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BPerformancePage"},
                        ["Button B7"]={template="BOscPage"},
                        ["Button B8"]={template="BOscPage"},
		},
		["Index"]={
			-- Select Drum
			["Button 6-1"]={template="BOscPage"},
			["Button 6-2"]={template="BOscPage"},
			["Button 7-1"]={template="BOscPage"},
			["Button 7-2"]={template="BOscPage"},
			["Button 7-3"]={template="BOscPage"},
			["Button 7-4"]={template="BOscPage"},
			["Button 8-1"]={template="BOscPage"},
			["Button 8-2"]={template="BOscPage"},
			["Button 8-3"]={template="BOscPage"},
			["Button 8-4"]={template="BOscPage"},
		},
		["Main"]={
			-- Sequence Step and toggle selected drum step
			["Button 1-1"]={template="BStep"},
			["Button 1-2"]={template="BStep"},
			["Button 1-3"]={template="BStep"},
			["Button 1-4"]={template="BStep"},
			["Button 1-5"]={template="BStep"},
			["Button 1-6"]={template="BStep"},
			["Button 1-7"]={template="BStep"},
			["Button 1-8"]={template="BStep"},
			["Button 2-1"]={template="BStep"},
			["Button 2-2"]={template="BStep"},
			["Button 2-3"]={template="BStep"},
			["Button 2-4"]={template="BStep"},
			["Button 2-5"]={template="BStep"},
			["Button 2-6"]={template="BStep"},
			["Button 2-7"]={template="BStep"},
			["Button 2-8"]={template="BStep"},
			-- Drum Select
			["Button 3-1"]={template="BOscSel"},
			["Button 3-2"]={template="BOscSel"},
			["Button 4-1"]={template="BOscSel"},
			["Button 4-2"]={template="BOscSel"},
			["Button 4-3"]={template="BOscSel"},
			["Button 4-4"]={template="BOscSel"},
			["Button 5-1"]={template="BOscSel"},
			["Button 5-2"]={template="BOscSel"},
			["Button 5-3"]={template="BOscSel"},
			["Button 5-4"]={template="BOscSel"},
			-- Edit Steps, Accent
			["Button 3-5"]={template="BPerformancePage"},
			["Button 3-6"]={template="BPerformancePage"},
			-- Edit Accent, color is handled elsewhere
			["Button 4-6"]={template="BRedOnOff"},
			-- Edit Steps
			["UDVButton 5-8_6-8"]={template="UDPerf"},
			-- Flam
			["UDVButton 7-7_8-7"]={template="UDPerf"},
			["Button 8-8"]={template="BRedOnOff"},
			-- Run
			["Button 3-8"]={template="BRun"},
			-- Play, Solo, Mute
			["Button 6-5"]={template="BMute"},
			["Button 7-5"]={template="BSoloRevival"},
			["Button 8-5"]={template="BPlaySel"},
			["Play"]={
				["Button 6-1"]={template="BPad"},
				["Button 6-2"]={template="BPad"},
				["Button 7-1"]={template="BPad"},
				["Button 7-2"]={template="BPad"},
				["Button 7-3"]={template="BPad"},
				["Button 7-4"]={template="BPad"},
				["Button 8-1"]={template="BPad"},
				["Button 8-2"]={template="BPad"},
				["Button 8-3"]={template="BPad"},
				["Button 8-4"]={template="BPad"},
			},
			["Solo"]={
				["Button 6-1"]={template="BSoloRevival"},
				["Button 6-2"]={template="BSoloRevival"},
				["Button 7-1"]={template="BSoloRevival"},
				["Button 7-2"]={template="BSoloRevival"},
				["Button 7-3"]={template="BSoloRevival"},
				["Button 7-4"]={template="BSoloRevival"},
				["Button 8-1"]={template="BSoloRevival"},
				["Button 8-2"]={template="BSoloRevival"},
				["Button 8-3"]={template="BSoloRevival"},
				["Button 8-4"]={template="BSoloRevival"},
			},
			["Mute"]={
				["Button 6-1"]={template="BMute"},
				["Button 6-2"]={template="BMute"},
				["Button 7-1"]={template="BMute"},
				["Button 7-2"]={template="BMute"},
				["Button 7-3"]={template="BMute"},
				["Button 7-4"]={template="BMute"},
				["Button 8-1"]={template="BMute"},
				["Button 8-2"]={template="BMute"},
				["Button 8-3"]={template="BMute"},
				["Button 8-4"]={template="BMute"},
			},
		},
		["Performance"]={
			-- Pattern enable
			["Button 1-1"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			-- Resolution, Shuffle
			["UDVButton 7-1_8-1"]={template="FPerf"},
			["UDVButton 7-4_8-4"]={template="FFreq"},
			["Button 8-5"]={template="BRedOnOff"},
			-- Pattern 1-4
			["Button 2-1"]={template="BPerformancePage"},
			["Button 2-2"]={template="BPerformancePage"},
			["Button 2-3"]={template="BPerformancePage"},
			["Button 2-4"]={template="BPerformancePage"},
			-- Pattern 5-8
			["Button 3-1"]={template="BPerformancePage"},
			["Button 3-2"]={template="BPerformancePage"},
			["Button 3-3"]={template="BPerformancePage"},
			["Button 3-4"]={template="BPerformancePage"},
			-- Bank A-D
			["Button 5-1"]={template="BPerformancePage"},
			["Button 5-2"]={template="BPerformancePage"},
			["Button 5-3"]={template="BPerformancePage"},
			["Button 5-4"]={template="BPerformancePage"},
			["Fader 8"]={template="FVol"},
		},
		["Drum *"]={
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
                        -- Goto Drum edit/main
                        ["Button 2-1"]={template="BOscPage"},
                        ["Button 3-1"]={template="BOscPage"},
			-- 
			["UDVButton 5-4_6-4"]={template="UDPerf"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Knob V7"]={template="FPan"},
			["Fader 8"]={template="FVol"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscPage"},
                        ["Button A3"]={template="BOscPage"},
                        ["Button A4"]={template="BOscPage"},
                        ["Button A5"]={template="BOscPage"},
                        ["Button A6"]={template="BOscPage"},
                        ["Button A7"]={template="BOscPage"},
                        ["Button A8"]={template="BOscPage"},
		},
		["Drum * Edit"]={
			["Button 1-1"]={template="BPad"},
			["Button 1-2"]={template="BMute"},
			["Button 1-3"]={template="BSolo"},
                        -- Goto Drum edit/main
                        ["Button 2-1"]={template="BOscPage"},
                        ["Button 3-1"]={template="BOscPage"},
			-- 
			["UDVButton 5-2_6-2"]={template="UDOsc"},
			["UDVButton 5-4_6-4"]={template="UDPerf"},
			["Fader 5"]={template="FFreq"},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
			["Knob V8"]={template="FPerf"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscPage"},
                        ["Button A3"]={template="BOscPage"},
                        ["Button A4"]={template="BOscPage"},
                        ["Button A5"]={template="BOscPage"},
                        ["Button A6"]={template="BOscPage"},
                        ["Button A7"]={template="BOscPage"},
                        ["Button A8"]={template="BOscPage"},
		},
	},
	["Revival"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BOscPage"},
                        ["Button B5"]={template="BOscPage"},
                        ["Button B6"]={template="BAmpPage"},
                        ["Button B7"]={template="BOscModPage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Index"]={
			["Button 2-4"]={template="BFilterPage"},
			["Button 3-4"]={template="BFilterPage"},
			["Button 4-4"]={template="BFilterPage"},
			["Button 5-4"]={template="BFilterPage"},
			["Button 2-5"]={template="BFilterModPage"},
			["Button 3-5"]={template="BFilterModPage"},
			["Button 4-5"]={template="BFilterModPage"},
			["Button 5-5"]={template="BFilterModPage"},
			["Button 2-6"]={template="BFilterModPage"},
			["Button 3-6"]={template="BFilterModPage"},
			["Button 4-6"]={template="BFilterModPage"},
			["Button 5-6"]={template="BFilterModPage"},
			["Button 2-7"]={template="BFilterModPage"},
			["Button 3-7"]={template="BFilterModPage"},
			["Button 4-7"]={template="BFilterModPage"},
			["Button 5-7"]={template="BFilterModPage"},
		},
		["Main"]={
			-- S1/S2 switches
			["Button 6-2"]={template="BYellowOnOff"},
			["Button 6-3"]={template="BYellowOnOff"},
			-- Attack Vib/Trem switches
			["Button 7-2"]={template="BYellowOnOff"},
			["Button 7-3"]={template="BYellowOnOff"},
			-- Rotator switches
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			-- R1/R2 knobs
			["Fader 4"]={template="FMisc"},
			["Fader 5"]={template="FMisc"},
			["BigFader 8"]={template="FVol"},
		},
		["Perf"]={
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq"},
			["UDVButton 1-3_2-3"]={template="UDPerf"},
			["Fader 7"]={template="FPerf"},
			["UDVButton 7-8_8-8"]={template="FPerf"},
		},
		["Voicing 1"]={
			["UDVButton 1-2_2-2"]={template="FOsc",inverted=true},
			["UDVButton 1-3_2-3"]={template="FOsc",inverted=true},
			["UDVButton 1-4_2-4"]={template="FPerf",inverted=true},
			["UDVButton 1-5_2-5"]={template="FOsc",inverted=true},
			["Fader 4"]={template="FOsc"},
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpPage"},
		},
		["Voicing 2"]={
			["Fader 1"]={template="FPerf"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FPerf"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FFreq"},
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpPage"},
		},
		["Pri/Sec"]={
			["UDVButton 1-2_2-2"]={template="UDOsc"},
			["UDVButton 1-3_2-3"]={template="UDOsc",inverted=true},
			["Knob V4"]={template="FOsc"},
			["Fader 6"]={template="FFreq"},
			["Button 1-7"]={template="BRedOnOff"},
		},
		["Solos"]={
			["Button 8-2"]={template="BSoloRevival"},
			["Button 8-4"]={template="BSoloRevival"},
			["Button 8-6"]={template="BSoloRevival"},
			["Button 8-8"]={template="BSoloRevival"},
		},
		["Attack"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A4"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BFilterModPage"},
			["UDVButton 1-2_2-2"]={template="UDOsc",inverted=true},
			["Fader 3"]={template="FVol"},
			["Fader 5"]={template="FOsc"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["Primary"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A4"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BFilterModPage"},
			["UDVButton 1-2_2-2"]={template="UDOsc",inverted=true},
			["Fader 3"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Secondary"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A4"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BFilterModPage"},
			["UDVButton 1-2_2-2"]={template="UDOsc",inverted=true},
			["Fader 3"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Release"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A4"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BFilterModPage"},
			["UDVButton 1-2_2-2"]={template="UDOsc",inverted=true},
			["Fader 3"]={template="FVol"},
			["Fader 5"]={template="FOsc"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
			["Button 1-8"]={template="BRedOnOff"},
		},
		["* Drawbars Lower"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A4"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BFilterModPage"},
			["Button 7-1"]={template="BOscPage"},
			["Button 8-1"]={template="BOscPage"},
			["Drawbar 2"]={template="DSub"},
			["Drawbar 3"]={template="DSub"},
			["Drawbar 4"]={template="DFund"},
			["Drawbar 5"]={template="DFund"},
			["Drawbar 6"]={template="DHarm"},
			["Drawbar 7"]={template="DFund"},
			["Drawbar 8"]={template="DHarm"},
		},
		["* Drawbars Upper"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A4"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BFilterModPage"},
			["Button 7-1"]={template="BOscPage"},
			["Button 8-1"]={template="BOscPage"},
			["Drawbar 2"]={template="DHarm"},
			["Drawbar 3"]={template="DHarm7"},
			["Drawbar 4"]={template="DFund"},
		},
		["* Mod Enable"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A4"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BFilterModPage"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 3-3"]={template="BRedOnOff"},
			["Button 3-4"]={template="BRedOnOff"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 3-6"]={template="BRedOnOff"},
			["Button 3-7"]={template="BRedOnOff"},
			["Button 3-8"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Button 4-3"]={template="BRedOnOff"},
			["Button 4-4"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Button 5-3"]={template="BRedOnOff"},
			["Button 5-4"]={template="BRedOnOff"},
			["Button 5-5"]={template="BRedOnOff"},
			["Button 5-6"]={template="BRedOnOff"},
			["Button 5-7"]={template="BRedOnOff"},
			["Button 5-8"]={template="BRedOnOff"},
			["Button 6-2"]={template="BRedOnOff"},
			["Button 6-3"]={template="BRedOnOff"},
			["Button 6-4"]={template="BRedOnOff"},
		},
		["* Mod *"]={
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscModPage"},
                        ["Button A3"]={template="BOscModPage"},
                        ["Button A4"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
                        ["Button A6"]={template="BFilterModPage"},
                        ["Button A7"]={template="BFilterModPage"},
			["UDVButton 5-2_6-2"]={template="UDFreq", inverted=true},
			["UDVButton 7-2_8-2"]={template="UDEffect", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FPerf"},
			["Fader 6"]={template="FPerf"},
			["Fader 7"]={template="FLFO"},
			["Fader 8"]={template="FFreq"},
		},
		["Effects"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-4"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Button 8-6"]={template="BRedOnOff"},
			["Fader 8"]={template="FEffect"},
		},
		["PreAmp"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FAmount"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
		},
		["Phaser"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
		},
		["ModFilter"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["UDVButton 1-5_2-5"]={template="UDFreq"},
			["UDVButton 7-5_8-5"]={template="UDLFO"},
			["Fader 6"]={template="FLFO"},
			["Fader 7"]={template="FFreq"},
			["UDVButton 7-7_8-7"]={template="UDFreq"},
		},
		["Speaker"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
			["Fader 3"]={template="FEffect"},
			["Knob V4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Knob V7"]={template="FVol"},
		},
		["Reverb"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Knob V4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
		},
		["Delay"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A4"]={template="BEffectPage"},
                        ["Button A5"]={template="BEffectPage"},
                        ["Button A6"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FEffect"},
		},
	},
	["Subtractor"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BOscPage"},
                        ["Button B4"]={template="BOscModPage"},
                        ["Button B5"]={template="BFilterPage"},
                        ["Button B6"]={template="BAmpPage"},
                        ["Button B7"]={template="BLFOPage"},
                        ["Button B8"]={template="BPerformancePage"},
		},
		["Index"]={
			["Button 1-3"]={template="BPerformancePage"},
			["Button 1-4"]={template="BPerformancePage"},
		},
		["Main"]={
			["Fader 8"]={template="FGain"},
		},
		["Perf"]={
			["UDVButton 7-3_8-3"]={template="UDPerf", inverted=true},
			["Fader 4"]={template="FPerf"},
			["UDVButton 7-5_8-5"]={template="UDPerf"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
		},
		["Osc *"]={
			["Knob V2"]={template="FOsc"},
			["UDVButton 1-3_2-3"]={template="UDOsc2", inverted=true},
			["UDVButton 3-3_4-3"]={template="UDOsc"},
			["UDVButton 3-4_4-4"]={template="UDFreq"},
			["UDVButton 3-5_4-5"]={template="UDFreq"},
			["UDVButton 3-6_4-6"]={template="UDFreq"},
			["Button 8-3"]={template="BRedOnOff"},
			["Button 8-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FOsc"},
			["Knob V8"]={template="FVol"},
		},
		["Osc 2"]={
			["Button 8-1"]={template="BRedOnOff"},
		},
		["Noise"]={
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["Fader 3"]={template="FOsc"},
			["Fader 4"]={template="FVol"},
		},
		["Filter"]={
			["Fader 2"]={template="FFreq"},
			["Fader 3"]={template="FEffect"},
			["UDVButton 1-4_2-4"]={template="UDFreq",inverted=true},
			["Fader 5"]={template="FPerf"},
			["Button 8-6"]={template="BRedOnOff"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterModPage"},
		},
		["Filter 2"]={
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FFreq"},
			["Fader 3"]={template="FEffect"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterModPage"},
		},
		["Filter Env"]={
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
			["Button 8-7"]={template="BRedOnOff"},
			["Fader 8"]={template="FEnv"},
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterModPage"},
		},
		["Amp Env"]={
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 8"]={template="FVol"},
		},
		["Mod Env"]={
			["Fader 2"]={template="FEnv"},
			["Fader 3"]={template="FEnv"},
			["Fader 4"]={template="FEnv"},
			["Fader 5"]={template="FEnv"},
			["UDVButton 5-7_6-7"]={template="UDEnv", inverted=true},
			["Button 8-7"]={template="BRedOnOff"},
			["Fader 8"]={template="FEnv"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A3"]={template="BEnvPage"},
		},
		["LFO 1"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", inverted=true},
			["UDVButton 1-3_2-3"]={template="UDLFO", inverted=true},
			["Button 8-4"]={template="BRedOnOff"},
			["Fader 5"]={template="FFreq"},
			["Fader 8"]={template="FLFO"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A3"]={template="BEnvPage"},
		},
		["LFO 2"]={
			["UDVButton 1-2_2-2"]={template="UDLFO", inverted=true},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FPerf"},
			["Fader 5"]={template="FEffect"},
			["Fader 8"]={template="FLFO"},
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A3"]={template="BEnvPage"},
		},
		["Velocity 1"]={
			["Knob V3"]={template="FVol"},
			["Knob V4"]={template="FOsc"},
			["Knob V5"]={template="FEnv"},
			["Knob V6"]={template="FOsc"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
		},
		["Velocity 2"]={
			["Knob V3"]={template="FFreq"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FFreq"},
			["Knob V6"]={template="FVol"},
			["Knob V7"]={template="FVol"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
		},
		["ModWheel Control"]={
			["Knob V3"]={template="FFreq"},
			["Knob V4"]={template="FEffect"},
			["Knob V5"]={template="FLFO"},
			["Knob V6"]={template="FOsc"},
			["Knob V7"]={template="FOsc"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
		},
		["ExtMod"]={
			["UDVButton 7-2_8-2"]={template="UDPerf", inverted=true},
			["Knob V3"]={template="FFreq"},
			["Knob V4"]={template="FLFO"},
			["Knob V5"]={template="FVol"},
			["Knob V6"]={template="FOsc"},
                        ["Button A1"]={template="BPerformancePage"},
                        ["Button A2"]={template="BPerformancePage"},
                        ["Button A3"]={template="BPerformancePage"},
                        ["Button A4"]={template="BPerformancePage"},
                        ["Button A5"]={template="BPerformancePage"},
		},
	},
	["Thor"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BAmpPage"},
                        ["Button B4"]={template="BFilterPage"},
                        ["Button B5"]={template="BAmpPage"},
                        ["Button B6"]={template="BLFOPage"},
                        ["Button B7"]={template="BPerformancePage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["Button 8-2"]={template="BRedOnOff"},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FMisc"},
			["Fader 5"]={template="FMisc"},
			["Fader 8"]={template="FGain"},
		},
		["Perf"]={
			["UDVButton 1-2_1-2"]={template="UDPerf"},
			["UDVButton 3-2_4-2"]={template="UDPerf2"},
			["UDVButton 5-2_6-2"]={template="UDPerf", inverted=true},
			["UDVButton 7-2_8-2"]={template="UDPerf2"},
			["Fader 3"]={template="FPerf"},
			["Button 1-4"]={template="BGreenOnOff"},
			["Button 2-4"]={template="BGreenOnOff"},
		},
		["Osc *"]={
			["Button 8-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDOsc", inverted=true},
			["UDVButton 1-3_2-3"]={template="UDPerf"},
			["UDVButton 1-4_2-4"]={template="UDFreq"},
			["UDVButton 1-5_2-5"]={template="UDFreq"},
			["UDVButton 1-6_2-6"]={template="UDFreq"},
			["Fader 8"]={template="FEffect"},
                        ["Button A1"]={template="BOscPage"},
                        ["Button A2"]={template="BOscPage"},
                        ["Button A3"]={template="BOscPage"},
			["Analog"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true},
				["Fader 7"]={template="FOsc"},
			},
			["Wavetable"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true},
				["Button 8-5"]={template="BRedOnOff"},
				["Fader 7"]={template="FOsc"},
			},
			["Phase Modulation"]={
				["UDVButton 7-3_8-3"]={template="UDOsc"},
				["UDVButton 7-4_8-4"]={template="UDOsc"},
				["Fader 7"]={template="FOsc"},
			},
			["FM Pair"]={
				["UDVButton 7-3_8-3"]={template="UDOsc"},
				["UDVButton 7-4_8-4"]={template="UDOsc"},
				["Fader 7"]={template="FOsc"},
			},
			["Multi Oscillator"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true},
				["UDVButton 7-5_8-5"]={template="UDOsc", inverted=true},
				["Fader 7"]={template="FOsc"},
			},
			["Noise"]={
				["UDVButton 7-3_8-3"]={template="UDOsc", inverted=true},
				["Fader 7"]={template="FOsc"},
			},
		},
		["Filter *"]={
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
			["Button 5-1"]={template="BRedOnOff"},
			["Button 6-1"]={template="BRedOnOff"},
			["Button 7-1"]={template="BRedOnOff"},
			["UDVButton 1-2_2-2"]={template="UDFreq", inverted=true},
			["Button 1-8"]={template="BGreenOnOff"},
			["UDVButton 3-8_4-8"]={template="UDEnv"},
			["UDVButton 5-8_6-8"]={template="UDPerf"},
			["UDVButton 7-8_8-8"]={template="UDPerf2"},
			["Low Pass"]={
				["Fader 3"]={template="FGain"},
				["Fader 4"]={template="FFreq"},
				["Fader 5"]={template="FEffect"},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true},
			},
			["State Variable"]={
				["Fader 3"]={template="FGain"},
				["Fader 4"]={template="FFreq"},
				["Fader 5"]={template="FEffect"},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true},
				["Fader 7"]={template="FEffect"},
			},
			["Comb"]={
				["Fader 3"]={template="FGain"},
				["Fader 4"]={template="FFreq"},
				["Fader 5"]={template="FEffect"},
				["Button 1-6"]={template="BGreenOnOff"},
				["UDVButton 3-6_4-6"]={template="UDFreq", inverted=true},
			},
			["Formant"]={
				["Fader 3"]={template="FGain"},
				["Fader 4"]={template="FEffect"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FEffect"},
			},
		},
		["Filter 2"]={
			["Button 8-1"]={template="BRedOnOff"},
		},
		["Filter Env"]={
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
			["Button 2-2"]={template="BGreenOnOff"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
		},
		["Mixer"]={
			["Knob V3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
		},
		["Amp"]={
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpModPage"},
			["UDVButton 3-2_4-2"]={template="UDGain"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FPerf"},
			["Fader 4"]={template="FVol"},
			["Knob V5"]={template="FPan"},
		},
		["Amp Env"]={
                        ["Button A1"]={template="BAmpPage"},
                        ["Button A2"]={template="BAmpModPage"},
			["Button 2-2"]={template="BGreenOnOff"},
			["Fader 3"]={template="FGain"},
			["Fader 4"]={template="FGain"},
			["Fader 5"]={template="FGain"},
			["Fader 6"]={template="FGain"},
		},
		["Mod Env"]={
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A5"]={template="BEnvPage"},
                        ["Button A6"]={template="BEnvPage"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BGreenOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEnv"},
			["Fader 5"]={template="FEnv"},
			["Fader 6"]={template="FEnv"},
		},
		["Global Env"]={ -- Global Env
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A5"]={template="BEnvPage"},
                        ["Button A6"]={template="BEnvPage"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BGreenOnOff"},
			["Button 4-1"]={template="BGreenOnOff"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEnv"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEnv"},
			["Fader 6"]={template="FEnv"},
			["Fader 7"]={template="FEnv"},
		},
		["LFO *"]={
                        ["Button A1"]={template="BLFOPage"},
                        ["Button A2"]={template="BLFOPage"},
                        ["Button A5"]={template="BEnvPage"},
                        ["Button A6"]={template="BEnvPage"},
                        ["UDVButton 1-2_2-2"]={template="UDLFO"},
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 2-1"]={template="BGreenOnOff"},
                        ["Fader 3"]={template="FFreq"},
                        ["Fader 4"]={template="FEffect"},
		},
		["LFO 1"]={
                        ["Fader 5"]={template="FPerf"},
		},
		["Step Sequencer"]={
			-- Sequence select
			["Button 1-1"]={template="BRedOnOff"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 2-5"]={template="BRedOnOff"},
			["Button 2-6"]={template="BRedOnOff"},
			["Button 2-7"]={template="BRedOnOff"},
			["Button 2-8"]={template="BRedOnOff"},
			-- Controls
			["Button 8-1"]={template="BRun"},
                        ["UDVButton 7-2_8-2"]={template="UDPerf"},
                        ["UDVButton 7-3_8-3"]={template="UDPerf", inverted=true},
			["Button 8-4"]={template="BGreenOnOff"},
                        ["UDVButton 7-5_8-5"]={template="UDFreq"},
                        ["UDVButton 7-6_8-6"]={template="UDPerf"},
                        ["UDVButton 7-7_8-7"]={template="UDFreq", inverted=true},
                        ["UDVButton 7-8_8-8"]={template="UDPerf"},
			-- Sequence Knobs
			["Note"]={
				["UDVButton 3-1_4-1"]={template="UDFreq"},
				["UDVButton 3-2_4-2"]={template="UDFreq"},
				["UDVButton 3-3_4-3"]={template="UDFreq"},
				["UDVButton 3-4_4-4"]={template="UDFreq"},
				["UDVButton 3-5_4-5"]={template="UDFreq"},
				["UDVButton 3-6_4-6"]={template="UDFreq"},
				["UDVButton 3-7_4-7"]={template="UDFreq"},
				["UDVButton 3-8_4-8"]={template="UDFreq"},
				["UDVButton 5-1_6-1"]={template="UDFreq2"},
				["UDVButton 5-2_6-2"]={template="UDFreq2"},
				["UDVButton 5-3_6-3"]={template="UDFreq2"},
				["UDVButton 5-4_6-4"]={template="UDFreq2"},
				["UDVButton 5-5_6-5"]={template="UDFreq2"},
				["UDVButton 5-6_6-6"]={template="UDFreq2"},
				["UDVButton 5-7_6-7"]={template="UDFreq2"},
				["UDVButton 5-8_6-8"]={template="UDFreq2"},
			},
			["Velocity"]={
				["UDVButton 3-1_4-1"]={template="UDPerf"},
				["UDVButton 3-2_4-2"]={template="UDPerf"},
				["UDVButton 3-3_4-3"]={template="UDPerf"},
				["UDVButton 3-4_4-4"]={template="UDPerf"},
				["UDVButton 3-5_4-5"]={template="UDPerf"},
				["UDVButton 3-6_4-6"]={template="UDPerf"},
				["UDVButton 3-7_4-7"]={template="UDPerf"},
				["UDVButton 3-8_4-8"]={template="UDPerf"},
				["UDVButton 5-1_6-1"]={template="UDPerf2"},
				["UDVButton 5-2_6-2"]={template="UDPerf2"},
				["UDVButton 5-3_6-3"]={template="UDPerf2"},
				["UDVButton 5-4_6-4"]={template="UDPerf2"},
				["UDVButton 5-5_6-5"]={template="UDPerf2"},
				["UDVButton 5-6_6-6"]={template="UDPerf2"},
				["UDVButton 5-7_6-7"]={template="UDPerf2"},
				["UDVButton 5-8_6-8"]={template="UDPerf2"},
			},
			["GateLen"]={
				["UDVButton 3-1_4-1"]={template="UDEffect"},
				["UDVButton 3-2_4-2"]={template="UDEffect"},
				["UDVButton 3-3_4-3"]={template="UDEffect"},
				["UDVButton 3-4_4-4"]={template="UDEffect"},
				["UDVButton 3-5_4-5"]={template="UDEffect"},
				["UDVButton 3-6_4-6"]={template="UDEffect"},
				["UDVButton 3-7_4-7"]={template="UDEffect"},
				["UDVButton 3-8_4-8"]={template="UDEffect"},
				["UDVButton 5-1_6-1"]={template="UDEffect2"},
				["UDVButton 5-2_6-2"]={template="UDEffect2"},
				["UDVButton 5-3_6-3"]={template="UDEffect2"},
				["UDVButton 5-4_6-4"]={template="UDEffect2"},
				["UDVButton 5-5_6-5"]={template="UDEffect2"},
				["UDVButton 5-6_6-6"]={template="UDEffect2"},
				["UDVButton 5-7_6-7"]={template="UDEffect2"},
				["UDVButton 5-8_6-8"]={template="UDEffect2"},
			},
			["StepDur"]={
				["UDVButton 3-1_4-1"]={template="UDFreq"},
				["UDVButton 3-2_4-2"]={template="UDFreq"},
				["UDVButton 3-3_4-3"]={template="UDFreq"},
				["UDVButton 3-4_4-4"]={template="UDFreq"},
				["UDVButton 3-5_4-5"]={template="UDFreq"},
				["UDVButton 3-6_4-6"]={template="UDFreq"},
				["UDVButton 3-7_4-7"]={template="UDFreq"},
				["UDVButton 3-8_4-8"]={template="UDFreq"},
				["UDVButton 5-1_6-1"]={template="UDFreq2"},
				["UDVButton 5-2_6-2"]={template="UDFreq2"},
				["UDVButton 5-3_6-3"]={template="UDFreq2"},
				["UDVButton 5-4_6-4"]={template="UDFreq2"},
				["UDVButton 5-5_6-5"]={template="UDFreq2"},
				["UDVButton 5-6_6-6"]={template="UDFreq2"},
				["UDVButton 5-7_6-7"]={template="UDFreq2"},
				["UDVButton 5-8_6-8"]={template="UDFreq2"},
			},
			["Curve1"]={
				["UDVButton 3-1_4-1"]={template="UDMisc"},
				["UDVButton 3-2_4-2"]={template="UDMisc"},
				["UDVButton 3-3_4-3"]={template="UDMisc"},
				["UDVButton 3-4_4-4"]={template="UDMisc"},
				["UDVButton 3-5_4-5"]={template="UDMisc"},
				["UDVButton 3-6_4-6"]={template="UDMisc"},
				["UDVButton 3-7_4-7"]={template="UDMisc"},
				["UDVButton 3-8_4-8"]={template="UDMisc"},
				["UDVButton 5-1_6-1"]={template="UDMisc2"},
				["UDVButton 5-2_6-2"]={template="UDMisc2"},
				["UDVButton 5-3_6-3"]={template="UDMisc2"},
				["UDVButton 5-4_6-4"]={template="UDMisc2"},
				["UDVButton 5-5_6-5"]={template="UDMisc2"},
				["UDVButton 5-6_6-6"]={template="UDMisc2"},
				["UDVButton 5-7_6-7"]={template="UDMisc2"},
				["UDVButton 5-8_6-8"]={template="UDMisc2"},
			},
			["Curve2"]={
				["UDVButton 3-1_4-1"]={template="UDMisc"},
				["UDVButton 3-2_4-2"]={template="UDMisc"},
				["UDVButton 3-3_4-3"]={template="UDMisc"},
				["UDVButton 3-4_4-4"]={template="UDMisc"},
				["UDVButton 3-5_4-5"]={template="UDMisc"},
				["UDVButton 3-6_4-6"]={template="UDMisc"},
				["UDVButton 3-7_4-7"]={template="UDMisc"},
				["UDVButton 3-8_4-8"]={template="UDMisc"},
				["UDVButton 5-1_6-1"]={template="UDMisc2"},
				["UDVButton 5-2_6-2"]={template="UDMisc2"},
				["UDVButton 5-3_6-3"]={template="UDMisc2"},
				["UDVButton 5-4_6-4"]={template="UDMisc2"},
				["UDVButton 5-5_6-5"]={template="UDMisc2"},
				["UDVButton 5-6_6-6"]={template="UDMisc2"},
				["UDVButton 5-7_6-7"]={template="UDMisc2"},
				["UDVButton 5-8_6-8"]={template="UDMisc2"},
			},
		},
		["Effects"]={
			["Button 8-1"]={template="BEffectPage"},
			["Button 8-2"]={template="BEffectPage"},
			["Button 8-3"]={template="BEffectPage"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
		},
		["Shaper"]={
			["Button 1-1"]={template="BGreenOnOff"},
                        ["UDVButton 1-2_2-2"]={template="UDEffect", inverted=true},
                        ["Fader 3"]={template="FEffect"},
			["UDVButton 7-4_8-4"]={template="UDAmount"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
		},
		["Delay"]={
			["Button 1-1"]={template="BGreenOnOff"},
			["Button 8-1"]={template="BGreenOnOff"},
                        ["Fader 2"]={template="FFreq"},
                        ["Fader 3"]={template="FEffect"},
                        ["Fader 5"]={template="FFreq"},
                        ["Fader 6"]={template="FLFO"},
                        ["Fader 8"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
		},
		["Chorus"]={
			["Button 1-1"]={template="BGreenOnOff"},
                        ["Fader 2"]={template="FFreq"},
                        ["Fader 3"]={template="FEffect"},
                        ["Fader 5"]={template="FFreq"},
                        ["Fader 6"]={template="FLFO"},
                        ["Fader 8"]={template="FEffect"},
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
		},
	},

	["Alligator"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BAmpPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BLFOPage"},
                        ["Button B6"]={template="BEffectPage"},
                        ["Button B7"]={template="BEffectPage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 3-2"]={template="BGreenOnOff"},
			["UDVButton 5-2_6-2"]={template="UDEffect"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["UDVButton 7-3_8-3"]={template="UDEffect"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 3-4"]={template="BRedOnOff"},
			["Button 5-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 3-5"]={template="BRedOnOff"},
			["Button 5-5"]={template="BRedOnOff"},
			["Fader 7"]={template="FGain"},
		},
		["HPFilter"]={
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
			["Button 1-2"]={template="BGreenOnOff"},
			["Knob V3"]={template="FLFO"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Knob V6"]={template="FEnv"},
		},
		["BPFilter"]={
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
			["Knob V3"]={template="FLFO"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Knob V6"]={template="FEnv"},
		},
		["LPFilter"]={
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
			["Knob V3"]={template="FLFO"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Knob V6"]={template="FEnv"},
		},
		["HPEffects"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A5"]={template="BAmpPage"},
			["Fader 2"]={template="FAmount"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Knob V6"]={template="FPan"},
			["Fader 7"]={template="FVol"},
		},
		["BPEffects"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A5"]={template="BAmpPage"},
			["Fader 2"]={template="FAmount"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Knob V6"]={template="FPan"},
			["Fader 7"]={template="FVol"},
		},
		["LPEffects"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A5"]={template="BAmpPage"},
			["Fader 2"]={template="FAmount"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Knob V6"]={template="FPan"},
			["Fader 7"]={template="FVol"},
		},
		["Delay"]={
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Button 1-3"]={template="BGreenOnOff"},
			["Fader 4"]={template="FEffect"},
			["Knob V5"]={template="FEffect"},
		},
		["Phaser"]={
			["Fader 2"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
		},
		["AmpEnv"]={
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
		},
		["DryLevels"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
                        ["Button A3"]={template="BEffectPage"},
                        ["Button A5"]={template="BAmpPage"},
			["Fader 2"]={template="FEffect"},
			["Knob V4"]={template="FPan"},
			["Fader 5"]={template="FVol"},
		},
		["FilterEnv"]={
                        ["Button A1"]={template="BFilterPage"},
                        ["Button A2"]={template="BFilterPage"},
                        ["Button A3"]={template="BFilterPage"},
                        ["Button A5"]={template="BFilterModPage"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
		},
		["LFO"]={
			["UDVButton 1-2_2-2"]={template="UDLFO"},
			["Fader 4"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq"},
			["Button 1-5"]={template="BGreenOnOff"},
		},
	},
	["Audiomatic"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 2"]={template="FGain"},
			["UDVButton 1-3_2-3"]={template="UDEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FVol"},
		},
	},
	["BV512 Digital Vocoder"]={
		["Default"]={
			["Fader 1"]={template="FVCGreen", bvmap="Fader VC"},
			["Fader 2"]={template="FVCGreen", bvmap="Fader VC"},
			["Fader 3"]={template="FVCGreen", bvmap="Fader VC"},
			["Fader 4"]={template="FVCGreen", bvmap="Fader VC"},
			["Fader 5"]={template="FVCGreen", bvmap="Fader VC"},
			["Fader 6"]={template="FVCGreen", bvmap="Fader VC"},
			["Fader 7"]={template="FVCGreen", bvmap="Fader VC"},
			["Fader 8"]={template="FVCGreen", bvmap="Fader VC"},
		},
		["Index"]={
			["UDVButton 7-1_8-1"]={template="UDNocolor"},
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Button 4-1"]={template="BRedOnOff"},
			["UDVButton 5-1_6-1"]={template="UDEffect"},
			["UDVButton 7-1_8-1"]={template="UDEffect"},
			["Fader 4"]={template="FAmount"},
			["Fader 5"]={template="FAmount"},
			["Knob V6"]={template="FGain"},
			["Fader 7"]={template="FFreq"},
			["Fader 8"]={template="FEffect"},
		},
	},
	["CF-101 Chorus/Flanger"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 3"]={template="FFreq"},
			["Knob V4"]={template="FEffect"},
			["Fader 5"]={template="FFreq"},
			["Button 1-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FLFO"},
			["Button 1-8"]={template="BRedOnOff"},
		},
	},
	["COMP-01 Compressor/Limiter"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Meter 8"]={template="FGain", bvmap="MeterSI"},
		},
	},
	["D-11 Foldback Distortion"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
		},
	},
	["DDL-1 Digital Delay Line"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["UDVButton 1-3_2-3"]={template="UDFreq"},
			["UDVButton 1-4_2-4"]={template="UDFreq", inverted=true},
			["UDVButton 1-5_2-5"]={template="UDFreq", inverted=true},
			["Fader 6"]={template="FEffect"},
			["Knob V7"]={template="FGain"},
			["Fader 8"]={template="FEffect"},
		},
	},
	["ECF-42 Filter"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BFilterModPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEnv"},
			["Fader 6"]={template="FPerf"},
			["UDVButton 1-7_2-7"]={template="UDFreq", inverted=true},
		},
		["Filter Envelope"]={
			["Fader 1"]={template="FEnv"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
		},
	},
	["MClass Compressor"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BEffectPage"},
		},
		["Index"]={
		},
		["Main"]={
			["Button 7-1"]={template="BRedLed"},
			["Button 8-1"]={template="BRedOnOff"},
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Knob V3"]={template="FGain"},
			["Fader 4"]={template="FEffect"},
			["Button 1-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect"},
			["Meter 7"]={template="InvMeter"},
			["Knob V8"]={template="FGain"},
		},
		["Env"]={
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Button 1-6"]={template="BRedOnOff"},
		},
	},
	["MClass Equalizer"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BFilterPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BFilterPage"},
                        ["Button B5"]={template="BFilterPage"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq"},
			["Knob V5"]={template="FGain"},
			["Fader 6"]={template="FEffect"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
		},
	},
	["MClass Maximizer"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BEffectPage"},
                        ["Button B3"]={template="BEffectPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Knob V3"]={template="FGain"},
			["Button 1-6"]={template="BRedOnOff"},
		},
		["Limiter"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Meter 3"]={template="InvMeter"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true},
			["UDVButton 1-5_2-5"]={template="UDEffect", inverted=true},
			["Knob V6"]={template="FGain"},
		},
		["SoftClip"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
		},
	},
	["MClass Stereo Imager"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Knob V3"]={template="FEffect"},
			["Meter 4"]={template="FGain", bvmap="MeterSI"},
			["Fader 5"]={template="FFreq", bvmap="Fader64"},
			["Knob V6"]={template="FEffect"},
			["Meter 7"]={template="FGain", bvmap="MeterSI"},
			["Button 1-6"]={template="BRedOnOff"},
			["UDVButton 1-8_2-8"]={template="UDPerf"},
			["UDVButton 7-8_8-8"]={template="UDEffect"},
		},
	},
	["Neptune Pitch Adjuster"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BOscPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BEffectPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 3"]={template="FEffect"},
			["Button 1-4"]={template="BYellowOnOff"},
			["Button 3-4"]={template="BYellowOnOff"},
			["Button 5-4"]={template="BYellowOnOff"},
			["UDVButton 7-4_8-4"]={template="UDEffect", inverted=true},
			["UDVButton 1-5_2-5"]={template="UDEffect"},
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
		},
		["PitchAdjust"]={
			["Button 1-2"]={template="BYellowOnOff"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
		},
		["Transpose"]={
			["Button 1-2"]={template="BYellowOnOff"},
			["UDVButton 1-4_2-4"]={template="UDFreq"},
			["UDVButton 5-4_6-4"]={template="UDFreq"},
		},
		["Formant"]={
			["Button 1-2"]={template="BYellowOnOff"},
			["Knob V5"]={template="FEffect"},
		},
	},
	["PEQ-2 Two Band Parametric EQ"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Knob V5"]={template="FGain"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
			["Knob V8"]={template="FGain"},
		},
	},
	["PH-90 Phaser"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BLFOPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
		},
		["LFO"]={
			["Fader 5"]={template="FFreq"},
			["Button 1-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FLFO"},
		},
	},
	["Polar Dual Pitch Shifter"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BEffectPage"},
                        ["Button B3"]={template="BAmpPage"},
                        ["Button B4"]={template="BEffectPage"},
                        ["Button B5"]={template="BEffectPage"},
                        ["Button B6"]={template="BEnvPage"},
                        ["Button B7"]={template="BLFOPage"},
                        ["Button B8"]={template="BFilterPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["UDVButton 1-3_2-3"]={template="UDEffect", inverted=true},
			["UDVButton 5-3_6-3"]={template="UDEffect", inverted=true},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 4"]={template="FFreq"},
			["Fader 6"]={template="FFreq"},
		},
		["Dry Signal"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["Knob V4"]={template="FPan"},
			["Knob V5"]={template="FLFO"},
			["Fader 8"]={template="FGain"},
		},
		["Delay Buffer"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 5-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["Button 1-4"]={template="BRedOnOff"},
			["Knob V5"]={template="FLFO"},
			["Knob V6"]={template="FEnv"},
		},
		["Shifter *"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
			["Button 1-1"]={template="BRedOnOff"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Knob V3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Knob V6"]={template="FLFO"},
			["Knob V7"]={template="FEnv"},
		},
		["Shifter * Vol"]={
                        ["Button A1"]={template="BEffectPage"},
                        ["Button A2"]={template="BEffectPage"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FLFO"},
			["Fader 6"]={template="FVol"},
		},
		["Envelope"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEnv"},
			["Fader 4"]={template="FEnv"},
			["Fader 5"]={template="FEnv"},
			["Fader 6"]={template="FEnv"},
			["Button 1-7"]={template="BRedOnOff"},
		},
		["LFO"]={
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Button 8-3"]={template="BRedOnOff"},
			["Fader 5"]={template="FLFO"},
			["UDVButton 7-6_8-6"]={template="UDLFO"},
		},
		["Filter"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 7-3_8-3"]={template="UDFreq", inverted=true},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FPerf"},
			["Knob V7"]={template="FLFO"},
			["Knob V8"]={template="FEnv"},
		},
	},
	["Pulveriser"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BFilterPage"},
                        ["Button B3"]={template="BLFOPage"},
                        ["Button B4"]={template="BEnvPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["UDVButton 7-1_8-1"]={template="UDPerf"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEnv"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FOsc"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FVol"},
		},
		["Filter"]={
			["UDVButton 1-2_2-2"]={template="UDFreq"},
			["Fader 3"]={template="FFreq"},
			["Fader 4"]={template="FEffect"},
			["Knob V7"]={template="FLFO"},
			["Knob V8"]={template="FEnv"},
		},
		["Follower"]={
			["Button 8-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect"},
			["Fader 4"]={template="FEnv"},
			["Fader 5"]={template="FEnv"},
		},
		["Tremor"]={
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Button 1-3"]={template="BGreenOnOff"},
			["UDVButton 1-4_2-4"]={template="UDEffect"},
			["Button 1-5"]={template="BGreenOnOff"},
			["Fader 6"]={template="FEffect"},
			["Knob V8"]={template="FVol"},
		},
	},
	["RV-7 Digital Reverb"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["UDVButton 1-3_2-3"]={template="UDEffect"},
			["Knob V4"]={template="FEffect"},
			["Knob V5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
		},
	},
	["RV7000 Advanced Reverb"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BEffectPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BEffectPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["Knob V5"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
		},
		["Reverb"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["SmallSpace"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FFreq"},
				["UDVButton 7-4_8-4"]={template="UDEffect"},
				["Fader 5"]={template="FFreq"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FFreq"},
				["Fader 8"]={template="FLFO"},
			},
			["Room"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["UDVButton 7-4_8-4"]={template="UDEffect"},
				["Fader 5"]={template="FEffect"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FFreq"},
				["Fader 8"]={template="FLFO"},
			},
			["Hall"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["UDVButton 7-4_8-4"]={template="UDEffect"},
				["Fader 5"]={template="FEffect"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FFreq"},
				["Fader 8"]={template="FLFO"},
			},
			["Arena"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FFreq"},
				["Fader 5"]={template="FFreq"},
				["Fader 6"]={template="FAmount"},
				["Fader 7"]={template="FFreq"},
				["Fader 8"]={template="FAmount"},
			},
			["Plate"]={
				["Fader 5"]={template="FFreq"},
				["Fader 7"]={template="FFreq"},
			},
			["Spring"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FFreq"},
				["Fader 5"]={template="FFreq"},
				["Button 8-6"]={template="BRedOnOff"},
				["Fader 7"]={template="FFreq"},
				["Fader 8"]={template="FAmount"},
			},
			["Echo"]={
				["Fader 2"]={template="FEffect"},
				["UDVButton 7-2_8-2"]={template="UDEffect"},
				["Fader 3"]={template="FEffect"},
				["Button 8-4"]={template="BRedOnOff"},
				["Fader 5"]={template="FFreq"},
				["Fader 6"]={template="FEffect"},
				["Fader 7"]={template="FFreq"},
			},
			["MultiTap"]={
				["Button 8-2"]={template="BRedOnOff"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FFreq"},
				["UDVButton 7-5_8-5"]={template="UDEffect"},
				["Fader 6"]={template="FFreq"},
				["UDVButton 7-6_8-6"]={template="UDFreq"},
				["Fader 7"]={template="FVol"},
				["Knob V8"]={template="FPan"},
			},
			["Reverse"]={
				["Fader 2"]={template="FEffect"},
				["UDVButton 7-2_8-2"]={template="UDEffect"},
				["Fader 3"]={template="FEffect"},
				["Button 8-6"]={template="BRedOnOff"},
				["Fader 5"]={template="FEffect"},
			},
			["Convolution"]={
				["UDVButton 7-2_8-2"]={template="UDEffect"},
				["Fader 3"]={template="FEffect"},
				["Knob V4"]={template="FEffect"},
				["Fader 5"]={template="FFreq"},
				["UDVButton 7-6_8-6"]={template="UDEffect"},
				["Knob V7"]={template="FFreq"},
				["Fader 8"]={template="FGain"},
			},
		},
		["Eq"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Knob V2"]={template="FGain"},
			["Fader 3"]={template="FFreq"},
			["Knob V5"]={template="FGain"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
		},
		["Gate"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEffect"},
			["Button 8-4"]={template="BRedOnOff"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
		},
	},
	["Saturation Knob"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 3"]={template="FEffect"},
			["UDVButton 1-4_2-4"]={template="UDEffect"},
		},
	},
	["Scream 4 Distortion"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BFilterPage"},
                        ["Button B3"]={template="BEffectPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["UDVButton 1-4_2-4"]={template="UDEffect", inverted=true},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FGain"},
		},
		["Cut"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Knob V4"]={template="FFreq"},
			["Knob V5"]={template="FFreq"},
			["Knob V6"]={template="FFreq"},
		},
		["Body"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["UDVButton 1-7_2-7"]={template="UDEffect", inverted=true},
		},
	},
	["Softtube Amp"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BFilterPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["UDVButton 1-2_2-2"]={template="UDEffect"},
			["UDVButton 5-2_6-2"]={template="UDEffect"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FGain"},
			["Fader 7"]={template="FGain"},
			["Fader 8"]={template="FVol"},
		},
		["Eq"]={
			["Fader 3"]={template="FGain"},
			["Fader 4"]={template="FGain"},
			["Fader 5"]={template="FGain"},
		},
	},
	["Softtube Bass Amp"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BFilterPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["UDVButton 1-2_2-2"]={template="UDEffect"},
			["UDVButton 5-2_6-2"]={template="UDEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 8"]={template="FVol"},
		},
		["Eq"]={
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FGain"},
			["Fader 4"]={template="FGain"},
			["UDVButton 7-5_8-5"]={template="UDFreq"},
			["Button 8-6"]={template="BRedOnOff"},
			["Fader 7"]={template="FGain"},
		},
	},
	["Synchronous"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BEffectPage"},
                        ["Button B3"]={template="BFilterPage"},
                        ["Button B4"]={template="BEffectPage"},
                        ["Button B5"]={template="BEffectPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["Fader 3"]={template="FGain"},
			["Button 8-4"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FGain"},
		},
		["Dist"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 3-2_4-2"]={template="UDEffect"},
			["Button 8-2"]={template="BRedOnOff"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
		},
		["Filter"]={
			["Button 1-2"]={template="BRedOnOff"},
			["UDVButton 3-2_4-2"]={template="UDEffect"},
			["Fader 4"]={template="FFreq"},
			["Fader 5"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Delay"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Button 3-2"]={template="BRedOnOff"},
			["Button 4-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["UDVButton 7-4_8-4"]={template="UDFreq"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 8-5"]={template="BRedOnOff"},
			["Fader 6"]={template="FEffect"},
			["Button 8-7"]={template="BRedOnOff"},
			["Knob V8"]={template="FEffect"},
		},
		["Reverb"]={
			["Button 1-2"]={template="BRedOnOff"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FFreq"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
			["Button 8-8"]={template="BRedOnOff"},
		},
	},
	["The Echo"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BEffectPage"},
                        ["Button B3"]={template="BEffectPage"},
                        ["Button B4"]={template="BEffectPage"},
                        ["Button B5"]={template="BLFOPage"},
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["UDVButton 1-2_2-2"]={template="UDEffect"},
			["Button 1-3"]={template="BYellowOnOff"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FEffect"},
		},
		["Delay"]={
			["Fader 2"]={template="FFreq"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Fader 3"]={template="FFreq"},
			["Button 1-4"]={template="BYellowOnOff"},
			["Button 4-4"]={template="BYellowOnOff"},
			["Button 8-5"]={template="BYellowOnOff"},
			["Knob V6"]={template="FEffect"},
		},
		["Feedback"]={
			["Fader 2"]={template="FEffect"},
			["Knob V3"]={template="FEffect"},
			["Button 1-5"]={template="BYellowOnOff"},
			["Fader 6"]={template="FEffect"},
			["Fader 7"]={template="FAmount"},
		},
		["Color"]={
			["Fader 2"]={template="FAmount"},
			["UDVButton 1-3_2-3"]={template="UDEffect"},
			["Button 1-5"]={template="BYellowOnOff"},
			["Fader 6"]={template="FFreq"},
			["Fader 7"]={template="FEffect"},
		},
		["Modulation"]={
			["Knob V2"]={template="FEnv"},
			["Fader 3"]={template="FEffect"},
			["Fader 5"]={template="FFreq"},
			["Fader 6"]={template="FLFO"},
		},
	},
	["UN-16 Unison"]={
		["Default"]={
		},
		["Index"]={
		},
		["Main"]={
			["UDVButton 1-1_2-1"]={template="UDEffect"},
			["UDVButton 1-3_2-3"]={template="UDEffect", inverted=true},
			["Fader 4"]={template="FEffect"},
			["Fader 8"]={template="FEffect"},
		},
	},

	["Matrix"]={
		["Default"]={
			-- Pattern Enable
			["Button 1-1"]={template="BRedOnOff"},
			-- Pattern
			["Button 2-1"]={template="BPerfOnOff"},
			["Button 2-2"]={template="BPerfOnOff"},
			["Button 2-3"]={template="BPerfOnOff"},
			["Button 2-4"]={template="BPerfOnOff"},
			["Button 3-1"]={template="BPerfOnOff"},
			["Button 3-2"]={template="BPerfOnOff"},
			["Button 3-3"]={template="BPerfOnOff"},
			["Button 3-4"]={template="BPerfOnOff"},
			-- Bank
			["Button 5-1"]={template="BPerfOnOff"},
			["Button 5-2"]={template="BPerfOnOff"},
			["Button 5-3"]={template="BPerfOnOff"},
			["Button 5-4"]={template="BPerfOnOff"},
			-- Resolution
			["UDVButton 7-8_8-8"]={template="UDFreq"},
			-- Run
			["Button 8-1"]={template="BRun"},
		},
	},
	["RPG-8"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BPerformancePage"},
		},
		["Main"]={
			-- MIDI-CV Coverter
			["Fader 2"]={template="FPerf"},
			["Button 1-3"]={template="BRedOnOff"},
			["UDVButton 3-3_4-3"]={template="UDFreq"},
			-- Arpeggiator
			["Button 1-4"]={template="BRedOnOff"},
			["UDVButton 3-4_4-4"]={template="UDEffect"},
			["UDVButton 5-4_6-4"]={template="UDFreq"},
			["UDVButton 7-4_8-4"]={template="UDEffect"},
			-- Sync and Time
			["Button 8-5"]={template="BRedOnOff"},
			["UDVButton 7-6_8-6"]={template="UDFreq"},
			["Fader 6"]={template="FFreq"},
			["Button 8-7"]={template="BRedOnOff"},
			["Fader 8"]={template="FEffect"},
		},
		["Pattern"]={
			-- Pattern Step
			["Button 1-1"]={template="BRedOnOff"},
			["Button 1-2"]={template="BRedOnOff"},
			["Button 1-3"]={template="BRedOnOff"},
			["Button 1-4"]={template="BRedOnOff"},
			["Button 1-5"]={template="BRedOnOff"},
			["Button 1-6"]={template="BRedOnOff"},
			["Button 1-7"]={template="BRedOnOff"},
			["Button 1-8"]={template="BRedOnOff"},
			["Button 2-1"]={template="BRedOnOff"},
			["Button 2-2"]={template="BRedOnOff"},
			["Button 2-3"]={template="BRedOnOff"},
			["Button 2-4"]={template="BRedOnOff"},
			["Button 2-5"]={template="BRedOnOff"},
			["Button 2-6"]={template="BRedOnOff"},
			["Button 2-7"]={template="BRedOnOff"},
			["Button 2-8"]={template="BRedOnOff"},
			-- Pattern Enable
			["Button 3-1"]={template="BRedOnOff"},
			-- Pattern Length Up
			["UDVButton 3-8_4-8"]={template="UDPerf"},
			-- Shuffle
			["Button 8-1"]={template="BRedOnOff"},
		},
	},
	["Pulsar"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BLFOPage"},
                        ["Button B3"]={template="BLFOPage"},
                        ["Button B4"]={template="BEnvPage"},
		},
		["Main"]={
			["Button 8-5"]={template="BRedOnOff"},
			["Knob V3"]={template="FMisc"},
			["Knob V4"]={template="FMisc"},
			["Knob V7"]={template="FMisc"},
		},
		["LFO *"]={
			["Button 7-1"]={template="BRedOnOff"},
			["Button 8-1"]={template="BRedOnOff"},
			["UDVButton 7-2_8-2"]={template="UDFreq"},
			["Fader 2"]={template="FFreq"},
			["Fader 4"]={template="FAmount"},
		},
		["Env"]={
			["Button 1-1"]={template="BRedOnOff"},
			["Button 1-2"]={template="BRedOnOff"},
			["Knob V5"]={template="FAmount"},
			["Knob V6"]={template="FFreq"},
			["Knob V7"]={template="FAmount"},
			["Knob V8"]={template="FFreq"},
		},
	},
	["Line Mixer 6:2"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BAmpPage"},
                        ["Button B3"]={template="BLFOPage"},
                        ["Button B4"]={template="BPerformancePage"},
                        ["Button B8"]={template="BEffectPage"},
		},
		["Main"]={
			["UDVButton 7-3_8-3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 6"]={template="FVol"},
		},
		["Level"]={
                        ["Button A7"]={template="BMute"},
                        ["Button A8"]={template="BSolo"},
			["Mute"]={
                        	["Button A1"]={template="BMute"},
                        	["Button A2"]={template="BMute"},
                        	["Button A3"]={template="BMute"},
                        	["Button A4"]={template="BMute"},
                        	["Button A5"]={template="BMute"},
                        	["Button A6"]={template="BMute"},
			},
			["Solo"]={
                        	["Button A1"]={template="BSolo"},
                        	["Button A2"]={template="BSolo"},
                        	["Button A3"]={template="BSolo"},
                        	["Button A4"]={template="BSolo"},
                        	["Button A5"]={template="BSolo"},
                        	["Button A6"]={template="BSolo"},
			},
			["Fader 1"]={template="FVol"},
			["Fader 2"]={template="FVol"},
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
		},
		["Pan"]={
			["Knob V1"]={template="FPan"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FPan"},
			["Knob V4"]={template="FPan"},
			["Knob V5"]={template="FPan"},
			["Knob V6"]={template="FPan"},
                        ["Button A7"]={template="BMute"},
                        ["Button A8"]={template="BSolo"},
			["Mute"]={
                        	["Button A1"]={template="BMute"},
                        	["Button A2"]={template="BMute"},
                        	["Button A3"]={template="BMute"},
                        	["Button A4"]={template="BMute"},
                        	["Button A5"]={template="BMute"},
                        	["Button A6"]={template="BMute"},
			},
			["Solo"]={
                        	["Button A1"]={template="BSolo"},
                        	["Button A2"]={template="BSolo"},
                        	["Button A3"]={template="BSolo"},
                        	["Button A4"]={template="BSolo"},
                        	["Button A5"]={template="BSolo"},
                        	["Button A6"]={template="BSolo"},
			},
		},
		["Meter"]={
                        ["Button A7"]={template="BMute"},
                        ["Button A8"]={template="BSolo"},
			["Mute"]={
                        	["Button A1"]={template="BMute"},
                        	["Button A2"]={template="BMute"},
                        	["Button A3"]={template="BMute"},
                        	["Button A4"]={template="BMute"},
                        	["Button A5"]={template="BMute"},
                        	["Button A6"]={template="BMute"},
			},
			["Solo"]={
                        	["Button A1"]={template="BSolo"},
                        	["Button A2"]={template="BSolo"},
                        	["Button A3"]={template="BSolo"},
                        	["Button A4"]={template="BSolo"},
                        	["Button A5"]={template="BSolo"},
                        	["Button A6"]={template="BSolo"},
			},
		},
		["Aux Send"]={
                        ["Button A7"]={template="BMute"},
                        ["Button A8"]={template="BSolo"},
			["Mute"]={
                        	["Button A1"]={template="BMute"},
                        	["Button A2"]={template="BMute"},
                        	["Button A3"]={template="BMute"},
                        	["Button A4"]={template="BMute"},
                        	["Button A5"]={template="BMute"},
                        	["Button A6"]={template="BMute"},
			},
			["Solo"]={
                        	["Button A1"]={template="BSolo"},
                        	["Button A2"]={template="BSolo"},
                        	["Button A3"]={template="BSolo"},
                        	["Button A4"]={template="BSolo"},
                        	["Button A5"]={template="BSolo"},
                        	["Button A6"]={template="BSolo"},
			},
			["Fader 1"]={template="FEffect"},
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FEffect"},
		},
	},
	["Mixer 14:2"]={
		["Default"]={
                        ["Button B1"]={template="BMainPage"},
                        ["Button B2"]={template="BPerformancePage"},
                        ["Button B3"]={template="BAmpPage"},
                        ["Button B4"]={template="BLFOPage"},
                        ["Button B7"]={template="BAmpPage"},
                        ["Button B8"]={template="BAmpPage"},
		},
		["Main"]={
			["Fader 2"]={template="FEffect"},
			["Fader 3"]={template="FEffect"},
			["Fader 4"]={template="FEffect"},
			["Fader 5"]={template="FEffect"},
			["Fader 6"]={template="FVol"},
		},
		["Index"]={
			["Button 2-2"]={template="BAmpPage"},
			["Button 2-3"]={template="BAmpPage"},
			["Button 7-1"]={template="BAmpPage"},
			["Button 7-2"]={template="BAmpPage"},
			["Button 7-3"]={template="BAmpPage"},
			["Button 7-4"]={template="BAmpPage"},
			["Button 7-5"]={template="BAmpPage"},
			["Button 7-6"]={template="BAmpPage"},
			["Button 7-7"]={template="BAmpPage"},
			["Button 8-1"]={template="BAmpPage"},
			["Button 8-2"]={template="BAmpPage"},
			["Button 8-3"]={template="BAmpPage"},
			["Button 8-4"]={template="BAmpPage"},
			["Button 8-5"]={template="BAmpPage"},
			["Button 8-6"]={template="BAmpPage"},
			["Button 8-7"]={template="BAmpPage"},
		},
		["Channel 1-7"]={
                       	["Button A1"]={template="BAmpPage"},
                       	["Button A2"]={template="BAmpPage"},
                       	["Button A3"]={template="BAmpPage"},
                       	["Button A4"]={template="BAmpPage"},
                       	["Button A5"]={template="BAmpPage"},
                       	["Button A6"]={template="BAmpPage"},
                       	["Button A7"]={template="BAmpPage"},
		},
		["Channel 8-14"]={
                       	["Button A1"]={template="BAmpPage"},
                       	["Button A2"]={template="BAmpPage"},
                       	["Button A3"]={template="BAmpPage"},
                       	["Button A4"]={template="BAmpPage"},
                       	["Button A5"]={template="BAmpPage"},
                       	["Button A6"]={template="BAmpPage"},
                       	["Button A7"]={template="BAmpPage"},
		},
		["Channel *"]={
                       	["Button A1"]={template="BAmpPage"},
                       	["Button A2"]={template="BAmpPage"},
                       	["Button A3"]={template="BAmpPage"},
                       	["Button A4"]={template="BAmpPage"},
                       	["Button A5"]={template="BAmpPage"},
                       	["Button A6"]={template="BAmpPage"},
                       	["Button A7"]={template="BAmpPage"},
			["Button 1-1"]={template="BAmpPage"},
			["Button 2-1"]={template="BFilterPage"},
			["Button 3-1"]={template="BEffectPage"},
			["ChannelMain"]={
				["Button 1-2"]={template="BMute"},
				["Button 2-2"]={template="BSolo"},
				["Knob V6"]={template="FPan"},
				["Fader 7"]={template="FVol"},
			},
			["ChannelEq"]={
				["Button 1-2"]={template="BYellowOnOff"},
				["Knob V4"]={template="FFreq"},
				["Knob V5"]={template="FFreq"},
			},
			["ChannelAuxSend"]={
				["Fader 2"]={template="FEffect"},
				["Fader 3"]={template="FEffect"},
				["Fader 4"]={template="FEffect"},
				["Fader 5"]={template="FEffect"},
				["Button 8-6"]={template="BYellowOnOff"},
			},
		},
		["Level 1-7"]={
                        ["Button 6-8"]={template="BAmpPage"},
                        ["Button 7-8"]={template="BMute"},
                        ["Button 8-8"]={template="BSolo"},
			["Channel"]={
                        	["Button A1"]={template="BAmpPage"},
                        	["Button A2"]={template="BAmpPage"},
                        	["Button A3"]={template="BAmpPage"},
                        	["Button A4"]={template="BAmpPage"},
                        	["Button A5"]={template="BAmpPage"},
                        	["Button A6"]={template="BAmpPage"},
                        	["Button A7"]={template="BAmpPage"},
			},
			["Mute"]={
                        	["Button A1"]={template="BMute"},
                        	["Button A2"]={template="BMute"},
                        	["Button A3"]={template="BMute"},
                        	["Button A4"]={template="BMute"},
                        	["Button A5"]={template="BMute"},
                        	["Button A6"]={template="BMute"},
                        	["Button A7"]={template="BMute"},
			},
			["Solo"]={
                        	["Button A1"]={template="BSolo"},
                        	["Button A2"]={template="BSolo"},
                        	["Button A3"]={template="BSolo"},
                        	["Button A4"]={template="BSolo"},
                        	["Button A5"]={template="BSolo"},
                        	["Button A6"]={template="BSolo"},
                        	["Button A7"]={template="BSolo"},
			},
			["Fader 1"]={template="FVol"},
			["Fader 2"]={template="FVol"},
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Level 8-14"]={
                        ["Button 6-8"]={template="BAmpPage"},
                        ["Button 7-8"]={template="BMute"},
                        ["Button 8-8"]={template="BSolo"},
			["Channel"]={
                        	["Button A1"]={template="BAmpPage"},
                        	["Button A2"]={template="BAmpPage"},
                        	["Button A3"]={template="BAmpPage"},
                        	["Button A4"]={template="BAmpPage"},
                        	["Button A5"]={template="BAmpPage"},
                        	["Button A6"]={template="BAmpPage"},
                        	["Button A7"]={template="BAmpPage"},
			},
			["Mute"]={
                        	["Button A1"]={template="BMute"},
                        	["Button A2"]={template="BMute"},
                        	["Button A3"]={template="BMute"},
                        	["Button A4"]={template="BMute"},
                        	["Button A5"]={template="BMute"},
                        	["Button A6"]={template="BMute"},
                        	["Button A7"]={template="BMute"},
			},
			["Solo"]={
                        	["Button A1"]={template="BSolo"},
                        	["Button A2"]={template="BSolo"},
                        	["Button A3"]={template="BSolo"},
                        	["Button A4"]={template="BSolo"},
                        	["Button A5"]={template="BSolo"},
                        	["Button A6"]={template="BSolo"},
                        	["Button A7"]={template="BSolo"},
			},
			["Fader 1"]={template="FVol"},
			["Fader 2"]={template="FVol"},
			["Fader 3"]={template="FVol"},
			["Fader 4"]={template="FVol"},
			["Fader 5"]={template="FVol"},
			["Fader 6"]={template="FVol"},
			["Fader 7"]={template="FVol"},
		},
		["Pan 1-7"]={
                        ["Button 6-8"]={template="BAmpPage"},
                        ["Button 7-8"]={template="BMute"},
                        ["Button 8-8"]={template="BSolo"},
			["Channel"]={
                        	["Button A1"]={template="BAmpPage"},
                        	["Button A2"]={template="BAmpPage"},
                        	["Button A3"]={template="BAmpPage"},
                        	["Button A4"]={template="BAmpPage"},
                        	["Button A5"]={template="BAmpPage"},
                        	["Button A6"]={template="BAmpPage"},
                        	["Button A7"]={template="BAmpPage"},
			},
			["Mute"]={
                        	["Button A1"]={template="BMute"},
                        	["Button A2"]={template="BMute"},
                        	["Button A3"]={template="BMute"},
                        	["Button A4"]={template="BMute"},
                        	["Button A5"]={template="BMute"},
                        	["Button A6"]={template="BMute"},
                        	["Button A7"]={template="BMute"},
			},
			["Solo"]={
                        	["Button A1"]={template="BSolo"},
                        	["Button A2"]={template="BSolo"},
                        	["Button A3"]={template="BSolo"},
                        	["Button A4"]={template="BSolo"},
                        	["Button A5"]={template="BSolo"},
                        	["Button A6"]={template="BSolo"},
                        	["Button A7"]={template="BSolo"},
			},
			["Knob V1"]={template="FPan"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FPan"},
			["Knob V4"]={template="FPan"},
			["Knob V5"]={template="FPan"},
			["Knob V6"]={template="FPan"},
			["Knob V7"]={template="FPan"},
		},
		["Pan 8-14"]={
                        ["Button 6-8"]={template="BAmpPage"},
                        ["Button 7-8"]={template="BMute"},
                        ["Button 8-8"]={template="BSolo"},
			["Channel"]={
                        	["Button A1"]={template="BAmpPage"},
                        	["Button A2"]={template="BAmpPage"},
                        	["Button A3"]={template="BAmpPage"},
                        	["Button A4"]={template="BAmpPage"},
                        	["Button A5"]={template="BAmpPage"},
                        	["Button A6"]={template="BAmpPage"},
                        	["Button A7"]={template="BAmpPage"},
			},
			["Mute"]={
                        	["Button A1"]={template="BMute"},
                        	["Button A2"]={template="BMute"},
                        	["Button A3"]={template="BMute"},
                        	["Button A4"]={template="BMute"},
                        	["Button A5"]={template="BMute"},
                        	["Button A6"]={template="BMute"},
                        	["Button A7"]={template="BMute"},
			},
			["Solo"]={
                        	["Button A1"]={template="BSolo"},
                        	["Button A2"]={template="BSolo"},
                        	["Button A3"]={template="BSolo"},
                        	["Button A4"]={template="BSolo"},
                        	["Button A5"]={template="BSolo"},
                        	["Button A6"]={template="BSolo"},
                        	["Button A7"]={template="BSolo"},
			},
			["Knob V1"]={template="FPan"},
			["Knob V2"]={template="FPan"},
			["Knob V3"]={template="FPan"},
			["Knob V4"]={template="FPan"},
			["Knob V5"]={template="FPan"},
			["Knob V6"]={template="FPan"},
			["Knob V7"]={template="FPan"},
		},
	},
}
local items = {
	{name = "Keyboard", input = "keyboard"},
	{name = "DeviceScope", output = "text" },
	{name = "DeviceName", output = "text" },
	{name = "PatchName", output = "text" },
	{name = "PageName", output = "text" },
	{name = "SubPageName", output = "text" },
	{name = "KbdPageName", output = "text" },
	{name = "DocPageName", output = "text" },
	{name = "PlayingStep", output = "text" },
	{name = "KeyboardMode", output = "text" },
	{name = "KbdVel", output = "text" },
	{name = "BaseKey", output = "text" },
	{name = "BarPosition", input= "button", output = "value", min = 0, max = 127},
	{name = "BeatPosition", input= "button", output = "value", min = 0, max = 127},
	{name = "EngineSelect", input= "value", output = "value", min = 0, max = 2, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "EffectSelect", input= "value", output = "value", min = 0, max = 5, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "EditSelect", input= "value", output = "value", min = 0, max = 2, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "LFOSelect", input= "value", output = "value", min = 0, max = 2, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "EnvSelect", input= "value", output = "value", min = 0, max = 3, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "Hidden", input = "delta", output = "value", min = 0, max = 127, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}},
	{name = "Fader 1", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 2", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 3", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 4", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 5", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 6", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 7", input = "value", output = "value", min = 0, max = 127},
	{name = "Fader 8", input = "value", output = "value", min = 0, max = 127},
	{name = "BigFader 1", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 2", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 3", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 4", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 5", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 6", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 7", input = "value", output = "value", min = 0, max = 1023},
	{name = "BigFader 8", input = "value", output = "value", min = 0, max = 1023},
	{name = "Drawbar 1", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 2", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 3", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 4", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 5", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 6", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 7", input = "value", output = "value", min = 0, max = 127},
	{name = "Drawbar 8", input = "value", output = "value", min = 0, max = 127},
	{name = "Meter 1", output = "value", min = 0, max = 68},
	{name = "Meter 2", output = "value", min = 0, max = 68},
	{name = "Meter 3", output = "value", min = 0, max = 68},
	{name = "Meter 4", output = "value", min = 0, max = 68},
	{name = "Meter 5", output = "value", min = 0, max = 68},
	{name = "Meter 6", output = "value", min = 0, max = 68},
	{name = "Meter 7", output = "value", min = 0, max = 68},
	{name = "Meter 8", output = "value", min = 0, max = 68},
	{name = "Knob V1", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V2", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V3", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V4", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V5", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V6", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V7", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob V8", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H1", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H2", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H3", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H4", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H5", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H6", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H7", input = "value", output = "value", min = 0, max = 127},
	{name = "Knob H8", input = "value", output = "value", min = 0, max = 127},
	{name = "Side LED", input = "value", output = "value", min = 0, max = 127},
}

local function hex_encode_text(text)
	local hexstring = ""
	
	for i = 1, #text do
		hexstring = hexstring..string.format("%02x ", string.byte(text:sub(i,i)))
	end

	return hexstring
end

-- Merge table2 into table1
function mergetables(table1, table2)
	for k,v in pairs(table2) do 
		table1[k] = v 
	end
end

function isbutton(button)
	return(button ~= nil and (button.x == 0x90 or button.x == 0xb0))
end
function gen_scroll_string(string, color, speed)
        return(string.format("%s %02x %02x %02x %s F7", MIDI_OUT_SCROLL, color, 0, speed, hex_encode_text(string)))
end

function get_veloctity(velocity)
	return(velocity)
end

function get_rgb_midi(color)
	r,g,b = string.match(color, "(..)(..)(..)")
	return(string.format("%02x %02x %02x", tonumber(r,16)/4, tonumber(g,16)/4, tonumber(b,16)/4))
end

function gen_color_midi(button, color)
	local buttonmidi = string.match(button, ".. (..)")
	return(string.format("f0 00 20 29 02 10 0b %s %s f7", buttonmidi, get_rgb_midi(color)))
end
function get_item_bvmap(itemname)
	local itemtype = string.match(itemname, "(.+%w)%s*%d")

	local currentpage = get_current_page()
	local scope = g_colorscheme

	local item_conf_map = get_item_conf_map(itemname, scope, currentpage)

	if(item_conf_map.bvmap ~= nil) then
		itemtype = item_conf_map.bvmap
	end

	if(item_bvmap[itemtype] == nil) then
		itemtype = "Default"
	end

	return(item_bvmap[itemtype])
end

function get_item_conf_map(itemname, context, page)
	if(string.match(get_current_page(), "Internal")) then
		context = "Default"
	end
	
	if(item_conf_map[context] == nil) then
		context = "Default"
	end

	if(string.match(itemname, "Button [A-H]$")) then
		page = get_current_docpage()
		context = "Default"
	end

	if(page == "Keyboard" and (get_current_kbdpage() == "Kbd" or get_current_kbdpage() == "Drum") and item_conf_map["Default"][page][get_current_kbdpage()][itemname] ~= nil) then
		return(item_conf_map["Default"][page][get_current_kbdpage()][itemname])
	end

	if((item_conf_map[context][page] ~= nil) and (item_conf_map[context][page][get_current_subpage()] ~= nil) and (item_conf_map[context][page][get_current_subpage()][itemname] ~= nil)) then
		return(item_conf_map[context][page][get_current_subpage()][itemname])
	end

	if(item_conf_map[context][page] == nil or item_conf_map[context][page][itemname] == nil) then
		wildpage = string.gsub(page, "%d+", "*")
		-- Parsec and Malstrom uses A/B naming
		wildpage = string.gsub(wildpage, " A", " *")
		wildpage = string.gsub(wildpage, " B", " *")
		-- Revival uses alternate naming of sections
		wildpage = string.gsub(wildpage, "Attack", "*")
		wildpage = string.gsub(wildpage, "Primary", "*")
		wildpage = string.gsub(wildpage, "Secondary", "*")
		wildpage = string.gsub(wildpage, "Release", "*")
		if((item_conf_map[context][wildpage] ~= nil) and (item_conf_map[context][wildpage][get_current_subpage()] ~= nil) and (item_conf_map[context][wildpage][get_current_subpage()][itemname] ~= nil)) then
			return(item_conf_map[context][wildpage][get_current_subpage()][itemname])
		end
		if(item_conf_map[context][wildpage] == nil or item_conf_map[context][wildpage][itemname] == nil) then
			if(item_conf_map[context]["Default"][itemname] == nil) then
				if(item_conf_map["Default"][page] == nil or item_conf_map["Default"][page][itemname] == nil) then
					context = "Default"
					page = "Default"
				else
					context = "Default"
				end	
			else
				page = "Default"
			end
		else
			page = wildpage
		end
	end

	local citem_conf_map = item_conf_map[context][page][itemname]

	if(not citem_conf_map) then
		local defaultitemname = string.gsub(itemname, " .+", " *")
		citem_conf_map = item_conf_map[context][page][defaultitemname]
	end

	return(citem_conf_map)
end

function get_button_color(context, itemname, buttonname, value)
	local color
	local buttonindex
	local buttonvalue = 0

	local enabled = remote.is_item_enabled(itemsindex[itemname])
	local value = remote.get_item_state(itemsindex[itemname]).value

	local citem_conf_map = get_item_conf_map(itemname, context, get_current_page())

	if(citem_conf_map.template ~= nil) then
		citem_conf_map_template = color_templates[citem_conf_map.template]	
	end

	-- Colors
	local activecolor = citem_conf_map.activecolor
	local enabledcolor = citem_conf_map.enabledcolor
	local disabledcolor = citem_conf_map.disabledcolor
	local dactivecolor = citem_conf_map.dactivecolor
	local denabledcolor = citem_conf_map.denabledcolor
	local maxcolor = citem_conf_map.maxcolor
	--Config
	local defaultvalue = citem_conf_map.defaultvalue

	if(citem_conf_map_template ~= nil) then
		if(activecolor == nil) then
			activecolor = citem_conf_map_template.activecolor
		end
		if(enabledcolor == nil) then
			enabledcolor = citem_conf_map_template.enabledcolor
		end
		if(disabledcolor == nil) then
			disabledcolor = citem_conf_map_template.disabledcolor
		end
		if(dactivecolor == nil) then
			dactivecolor = citem_conf_map_template.dactivecolor
		end
		if(denabledcolor == nil) then
			denabledcolor = citem_conf_map_template.denabledcolor
		end
		if(maxcolor == nil) then
			maxcolor = citem_conf_map_template.maxcolor
		end
		if(defaultvalue == nil) then
			defaultvalue = citem_conf_map_template.defaultvalue
		end
	end

	if(denabledcolor == nil) then
		denabledcolor = enabledcolor
	end
	if(dactivecolor == nil) then
		dactivecolor = activecolor
	end

	local value = remote.get_item_value(itemsindex[itemname])
	local textvalue = tonumber(remote.get_item_text_value(itemsindex[itemname]))
	local text = remote.get_item_text_value(itemsindex[itemname])

	if(string.find(itemname, "UDHButton %d%-%d_%d%-%d") or string.find(itemname, "UDVButton %d%-%d_%d%-%d")) then
        	if(enabled) then
                	if(value) then
                        	color = activecolor
                	else
                        	color = enabledcolor
                	end
        	else
                	color = disabledcolor
        	end
	elseif(string.find(itemname, "Button %d%-%d") or string.find(itemname, "Button C%d") or string.find(itemname, "Button %a")) then
		if(g_scopetext == "Redrum" and string.match(get_current_page(), "Main") and (string.match(itemname, "Button [12]%-%d"))) then
			if(g_playingbutton == itemname and (tonumber(remote.get_item_text_value(itemsindex["Button 3-8"])) == 1)) then
                       		color = REDRUM_HIT
			else 
				if(textvalue == 1) then
                       			color = REDRUM_SOFT
				elseif(textvalue == 2) then
                       			color = REDRUM_MEDIUM
				elseif(textvalue == 3) then
                       			color = REDRUM_HARD
				else
                       			color = REDRUM_NOHIT
				end
			end
		elseif(g_scopetext == "Redrum" and string.match(get_current_page(), "Main") and (string.match(itemname, "Button 4%-6"))) then
			if(textvalue == 1) then
                       		color = REDRUM_SOFT
			elseif(textvalue == 2) then
                       		color = REDRUM_MEDIUM
			elseif(textvalue == 3) then
                       		color = REDRUM_HARD
			else
                       		color = REDRUM_NOHIT
			end
		elseif(g_scopetext == "Thor" and string.match(get_current_page(), "Step Sequencer") and (string.match(itemname, "Button [12]%-%d"))) then
			if(g_playingbutton == itemname and (tonumber(remote.get_item_value(itemsindex["Button 8-1"])) == 1)) then
                       		color = THOR_SEQ_ACTIVE
			else 
				if(value == 1) then
                       			color = THOR_SEQ_STEPON
				else
                       			color = THOR_SEQ_STEPOFF
				end
			end
		else
        		if(enabled) then
                		if(value == 1) then
                        		color = activecolor
                		else
                        		color = enabledcolor
                		end
        		else
                		color = disabledcolor
        		end
		end
	elseif(string.find(itemname, "Knob H%d")) then
		buttonindex = tonumber(string.sub(buttonname, -1,-1))
		if(value > 64) then
			if(buttonindex >= 5) then
				buttonvalue = get_item_bvmap(itemname)[buttonindex-1]
				if(value > buttonvalue) then
					color = activecolor
				else 
					color = enabledcolor
				end
			else
				color = enabledcolor
			end
		elseif(value < 64) then
			if(buttonindex <= 4) then
				buttonvalue = get_item_bvmap(itemname)[buttonindex]
				if(value <= buttonvalue) then
					color = activecolor
				else 
					color = enabledcolor
				end
			else
				color = enabledcolor
			end
		else
			if(buttonindex == 4 or buttonindex == 5) then
				color = activecolor
			else
				color = enabledcolor
			end
		end
	elseif(string.find(itemname, "Knob V%d")) then
		buttonindex = tonumber(string.sub(buttonname, -3,-3))
		if(value > 64) then
			if(buttonindex <= 4) then
				buttonvalue = get_item_bvmap(itemname)[buttonindex+1]
				if(value > buttonvalue) then
					color = activecolor
				else 
					color = enabledcolor
				end
			else
				color = enabledcolor
			end
		elseif(value < 64) then
			if(buttonindex >= 5) then
				buttonvalue = get_item_bvmap(itemname)[buttonindex-1]
				if(value < buttonvalue) then
					color = activecolor
				else 
					color = enabledcolor
				end
			else
				color = enabledcolor
			end
		else
			if(buttonindex == 4 or buttonindex == 5) then
				color = activecolor
			else
				color = enabledcolor
			end
		end
	else
		if(string.find(itemname, "Drawbar %d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		elseif(string.find(itemname, "Meter %d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		elseif(string.find(itemname, "BigFader %d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		elseif(string.find(itemname, "Fader %d")) then
			buttonindex = tonumber(string.sub(buttonname, -3,-3))
			buttonvalue = get_item_bvmap(itemname)[buttonindex]
		end

		if(value >= buttonvalue) then
			if(string.find(itemname, "Meter %d") and buttonindex == 0) then
				color = maxcolor
			else 
				if((string.find(itemname, "BigFader %d") or string.find(itemname, "Fader %d")) and buttonvalue == defaultvalue) then
					color = dactivecolor
				else
					color = activecolor
				end
			end
		else 
			if((string.find(itemname, "BigFader %d") or string.find(itemname, "Fader %d")) and buttonvalue == defaultvalue) then
				color = denabledcolor
			else
				color = enabledcolor
			end
		end
	end

	return color
end

function get_item_by_button(buttonname) 
        for i=1,8 do
		local fadername = "Fader "..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
        for i=1,8 do
		local fadername = "BigFader "..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
        for i=1,8 do
		local fadername = "Drawbar "..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
        for i=1,8 do
		local fadername = "Meter "..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
        for i=1,8 do
		local fadername = "Knob H"..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button "..tostring(i).."%-%d")) then
				return fadername
			end
		end
	end
        for i=1,8 do
		local fadername = "Knob V"..tostring(i)
		if(remote.is_item_enabled(itemsindex[fadername])) then
			if(string.find(buttonname, "Button %d%-"..tostring(i))) then
				return fadername
			end
		end
	end
	for row=1,8 do
		for column=1,8,2 do
			local udhbuttonname = "UDHButton "..row.."-"..column.."_"..row.."-"..tostring(column+1)
			if(remote.is_item_enabled(itemsindex[udhbuttonname])) then
				if(string.find(buttonname, "Button "..row.."%-"..column)) then
					return udhbuttonname
				elseif(string.find(buttonname, "Button "..row.."%-"..tostring(column+1))) then
					return udhbuttonname
				end
			end
		end
	end
	for row=1,8,2 do
		for column=1,8 do
			local udvbuttonname = "UDVButton "..row.."-"..column.."_"..tostring(row+1).."-"..column
			if(remote.is_item_enabled(itemsindex[udvbuttonname])) then
				if(string.find(buttonname, "Button "..row.."%-"..column)) then
					return udvbuttonname
				elseif(string.find(buttonname, "Button "..tostring(row+1).."%-"..column)) then
					return udvbuttonname
				end
			end
		end
	end
	return buttonname
end

function get_current_page()
	local pagename = "Unknown"

	if(remote.is_item_enabled(itemsindex["PageName"])) then
		pagename = remote.get_item_text_value(itemsindex["PageName"])
	end

	return pagename
end

function get_current_kbdpage()
	local kbdpagename = "Unknown"

	if(remote.is_item_enabled(itemsindex["KbdPageName"])) then
		kbdpagename = remote.get_item_text_value(itemsindex["KbdPageName"])
	end

	return kbdpagename
end

function get_current_subpage()
	local subpagename = "Unknown"

	if(remote.is_item_enabled(itemsindex["SubPageName"])) then
		subpagename = remote.get_item_text_value(itemsindex["SubPageName"])
	end

	return subpagename
end

function get_current_docpage()
	local pagename = "Unknown"

	if(remote.is_item_enabled(itemsindex["DocPageName"])) then
		pagename = remote.get_item_text_value(itemsindex["DocPageName"])
	end

	return pagename
end

function lightshow_bars(buttonname, cyclelength, orientation) 
	local color
	
	if(g_updatetime + cyclelength < remote.get_time_ms()) then
		g_lightshowcycle = g_lightshowcycle + 1
		if(g_lightshowcycle > 8) then
			g_lightshowcycle = 1
		end
		g_updatetime = remote.get_time_ms()
	end

	if(string.match(buttonname, "Button C%d") or string.match(buttonname, "Button %a")) then
		color = NOCOLOR
	else
		local row
		local col
		row, col = string.match(buttonname, "Button (%d)%-(%d)")
		local dim
		if(orientation == 1) then
			dim = row
		else 
			dim = col
		end
		local cloop = tonumber(dim) - g_lightshowcycle
		if(cloop < 1) then
			cloop = cloop + 8
		end
		color = gradient[cloop]
	end
	return color
end

function lightshow_center(buttonname, cyclelength) 
	local color
	
	if(g_updatetime + cyclelength < remote.get_time_ms()) then
		g_lightshowcycle = g_lightshowcycle + 1
		if(g_lightshowcycle > 4) then
			g_lightshowcycle = 1
			g_lightshowloop = g_lightshowloop + 1
			if(g_lightshowloop > 8) then
				g_lightshowloop = 1
			end
		end
		g_updatetime = remote.get_time_ms()
	end

	if(string.match(buttonname, "Button C%d") or string.match(buttonname, "Button %a")) then
		color = NOCOLOR
	else
		local row
		local col
		row, col = string.match(buttonname, "Button (%d)%-(%d)")

		local x
		local y

		if(tonumber(row) >= 5) then
			x = tonumber(row) - 4
		else 
			x = 5-tonumber(row)
		end
		if(tonumber(col) >= 5) then
			y = tonumber(col) - 4
		else 
			y = 5-tonumber(col)
		end
		if(x <= g_lightshowcycle and y <= g_lightshowcycle) then
			color = gradient[g_lightshowloop]
		else
			color = NOCOLOR
		end
	end
	return color
end

function get_button_name(button)
	local midistring = string.format("%02x %02x", button.x, button.y)
	return(midi_to_button[midistring])
end

function get_knob_type(itemname)
	return(string.match(itemname, ".+ (.).+"))
end

function get_item_type(itemname)
	return(string.match(itemname, "(.+) .+"))
end

function get_button_row(buttonname)
	return(tonumber(string.match(buttonname, "Button (%d)%-%d")))
end

function get_button_col(buttonname)
	return(tonumber(string.match(buttonname, "Button %d%-(%d)")))
end

function is_up_udupbutton(buttonname, itemname)
	local upbutton

	udtype,first,second = string.match(itemname, "UD(.)Button (...)_(...)")

	if(udtype == 'V') then
		if(get_item_conf_map(itemname, g_colorscheme, get_current_page()).inverted) then
			upbutton = second
		else
			upbutton = first
		end
	else
		if(get_item_conf_map(itemname, g_colorscheme, get_current_page()).inverted) then
			upbutton = first
		else
			upbutton = second
		end
	end

	return(buttonname == "Button "..upbutton)
end
function init_buttons()
	for buttonname,buttonmidi in pairs(buttons) do
		table.insert(items, {name = buttonname, input = "button", output="value", modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}})
		table.insert(inputs, {pattern=buttonmidi .. " ?<???x>", name=buttonname})
	end
end

function init_udbuttons()
	for row=1,8 do
		for column=1,8,2 do
			table.insert(items, {name = "UDHButton "..row.."-"..column.."_"..row.."-"..tostring(column+1), input = "delta", output="value", min = 0, max = 127, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}})
		end
	end

	for row=1,8,2 do
		for column=1,8 do
			table.insert(items, {name = "UDVButton "..row.."-"..column.."_"..tostring(row+1).."-"..column, input = "delta", output="value", min = 0, max = 127, modes={"NORMAL", "SEL1", "SEL2", "SEL3", "SEL4"}})
		end
	end
end

function init_sel()
	for sel=1,4 do
		for val=0,127 do
			table.insert(items, {name = "Sel"..sel.."_"..val, input= "button", output = "value", min = 0, max = 1})
		end
	end
end

function init_itemsindex()
	for index,item in ipairs(items) do
		itemsindex[item.name] = index
		itemsmodeindex[item.name] = {}
		if(item.modes ~= nil) then
			for mindex,mode in ipairs(item.modes) do
				itemsmodeindex[item.name][mode] = mindex
			end
		end
	end
end

function init_miditobutton()
	for button,midi in pairs(buttons) do
		midi_to_button[midi] = button
	end
end

function handle_input_sel(event, selnum)
	for selnum=1,g_selcount do
        	if(g_sel[selnum] ~= nil) then
                	local msg = { time_stamp = event.time_stamp, item = itemsindex["Sel"..selnum.."_"..g_sel[selnum]], value = 1 }
                	remote.handle_input(msg)
                	g_sel[selnum] = nil
                	g_updateall = true
        	end
        end
end

function handle_input_select(event)
	for itemname,value in pairs(g_select) do
		local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
		remote.handle_input(msg)
		g_select[itemname] = nil
	end
end

function handle_input_scrollend(event)
	local msg_scrollend = remote.match_midi(MIDI_IN_SCROLLEND, event)
	if(msg_scrollend ~= nil) then
		g_scrolling = false
		g_updateall = true
		return true
	end
end

function handle_input_lightshow(event)
	for buttonname,buttonmidi in pairs(buttons) do
		local button = remote.match_midi(buttonmidi.." zz", event)
		if(button ~= nil and button.z > 0) then
			return true
		end
                local button = remote.match_midi(buttonmidi.." 00", event)
                if(button ~= nil) then
                        if(g_lightshowtime + 500 < remote.get_time_ms()) then
				g_lightshow = 0
				g_updateall = true
                        end
                        return true
                end
        end
end

function handle_input_kong(event, button)
	if(g_scopetext == "Kong" and get_current_page() == "Main") then
		local buttonname = get_button_name(button)
		local padnote = button_to_padnote[buttonname]
		if(padnote ~= nil) then
			remote.handle_input({ time_stamp = event.time_stamp, item = 1, value = 1, note = padnote, velocity = button.z })
			return true
		end
	end
end

function handle_input_keyboard(event, button)
	local velocity = get_veloctity(button.z)
	if(get_current_page() == "Keyboard" and get_current_kbdpage() == "Kbd") then
		buttonname = get_button_name(button)
		keynote = button_to_keynote[buttonname]
		if(keynote ~= nil) then
			remote.handle_input({ time_stamp = event.time_stamp, item = 1, value = 1, note = (keynote+12*g_basekey), velocity = velocity })
			return true
		end
	elseif(get_current_page() == "Keyboard" and get_current_kbdpage() == "Drum") then
		local buttonname = get_button_name(button)
		local padnote = button_to_fullpadnote[buttonname]
		if(padnote ~= nil) then
			remote.handle_input({ time_stamp = event.time_stamp, item = 1, value = 1, note = padnote, velocity = velocity })
			return true
		end
	end
end

function handle_input_item(event, button)
	local buttonname = get_button_name(button)
	local row = get_button_row(buttonname)
	local col = get_button_col(buttonname)
	local itemname = get_item_by_button(buttonname)
	if(button.z > 0) then
		if(buttonname ~= itemname) then
			local itemtype = get_item_type(itemname)
			if(itemtype == "Fader" or itemtype == "BigFader" or itemtype == "Drawbar") then
				local value = get_item_bvmap(itemname)[row]
				local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
				remote.handle_input(msg)
				return(true)
			elseif(itemtype == "Knob") then
				local oldvalue = remote.get_item_value(itemsindex[itemname])
				local value

				if(get_knob_type(itemname) == 'H') then
					value = get_item_bvmap(itemname)[col]
					if((oldvalue < 64 and col == 5) or (oldvalue > 64 and col == 4)) then
						value = 64
					end
				else
					value = get_item_bvmap(itemname)[row]
					if((oldvalue > 64 and row == 5) or (oldvalue < 64 and row == 4)) then
						value = 64
					end
				end
				local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
				remote.handle_input(msg)
				return(true)
			elseif(itemtype == "UDVButton" or itemtype == "UDHButton") then
				local value = 1
				if(is_up_udupbutton(buttonname, itemname)) then
					value = 1
				else
					value = -1
				end
				local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = value }
				remote.handle_input(msg)
				return(true)
			end
		end
	else
		local itemtype = get_item_type(itemname)
		if(itemtype == "Knob") then
			if(get_item_conf_map(itemname,g_colorscheme, get_current_page()).resetonrel) then
				local msg = { time_stamp = event.time_stamp, item = itemsindex[itemname], value = 64 }
				remote.handle_input(msg)
				return true
			end
		end
	end
end

function handle_input_helpmode(event, button)
	if(button.z == 0) then
		g_helpmode = false
		g_stopflashing = true
		g_scrollcolor = S_RED
		g_updateall = true
		local buttonname = get_button_name(button)
		local itemname = get_item_by_button(buttonname)

		if(itemname == "Button C1" or itemname == "Button C2") then
			g_scrolltext = g_scopetext
		elseif(itemname == "Button C3" or itemname == "Button C4") then
			g_scrolltext = remote.get_item_text_value(itemsindex["PatchName"])
		elseif(itemname == "Button C7") then
			g_scrolltext = get_current_page()
		elseif(itemname == "Button D8") then
			g_scrolltext = get_current_docpage()
		elseif(itemname == "Button C8") then
			g_valuemode = true
			g_startflashing = true
		else
			g_scrolltext = remote.get_item_name(itemsindex[itemname])
		end
		if(g_scrolltext == "") then
			g_scrolltext = get_item_conf_map(itemname, g_colorscheme, get_current_page()).helptext
			if(g_scrolltext == nil) then
				g_scrolltext = "Unknown"
			end
		end
		return true
	end
end

function handle_input_valuemode(event, button)
	if(button.z == 0) then
		g_valuemode = false
		g_stopflashing = true
		g_scrollcolor = S_YELLOW
		g_updateall = true
		local buttonname = get_button_name(button)
		local itemname = get_item_by_button(buttonname)

		if(itemname == "Button C1" or itemname == "Button C2") then
			g_scrolltext = remote.get_item_text_value(itemsindex["DeviceName"])
		elseif(itemname == "Button C8") then
			return true
		else
			g_scrolltext = tostring(remote.get_item_value(itemsindex[itemname]))
		end

		if(g_scrolltext == "") then
			g_scrolltext = "Unknown"
		end
		return true
	end
end

function handle_input_internalpage(event, button)
	if(string.match(get_current_page(), "Internal")) then
		local button_brightnessup = remote.match_midi(buttons["Button 7-8"].." zz", event)
		local button_brightnessdown = remote.match_midi(buttons["Button 8-8"].." zz", event)
		if(button_brightnessup ~= nil and button_brightnessup.z > 0) then
			if(g_brightness_new < 5) then
				g_brightness_new = g_brightness_new+1
			end
			return true
		elseif(button_brightnessdown ~= nil and button_brightnessdown.z > 0) then
			if(g_brightness_new > 1) then
				g_brightness_new = g_brightness_new-1
			end
			return true
		end
		local button_lightshow1 = remote.match_midi(buttons["Button 1-6"].." zz", event)
		if(button_lightshow1 ~= nil and button_lightshow1.z > 0) then
			g_lightshow = 1
			g_lightshowtime = remote.get_time_ms()
			g_updatetime = remote.get_time_ms()
			g_lightshowcycle = 1
			return true
		end
		local button_lightshow2 = remote.match_midi(buttons["Button 1-7"].." zz", event)
		if(button_lightshow2 ~= nil and button_lightshow2.z > 0) then
			g_lightshow = 2
			g_lightshowtime = remote.get_time_ms()
			g_updatetime = remote.get_time_ms()
			g_lightshowcycle = 1
			return true
		end
		local button_lightshow3 = remote.match_midi(buttons["Button 1-8"].." zz", event)
		if(button_lightshow3 ~= nil and button_lightshow3.z > 0) then
			g_lightshow = 3
			g_lightshowtime = remote.get_time_ms()
			g_updatetime = remote.get_time_ms()
			g_lightshowcycle = 1
			return true
		end
		local button_lightshow4 = remote.match_midi(buttons["Button 2-8"].." zz", event)
		if(button_lightshow4 ~= nil and button_lightshow4.z > 0) then
			g_lightshow = 4
			g_lightshowtime = remote.get_time_ms()
			g_updatetime = remote.get_time_ms()
			g_lightshowcycle = 1
			g_lightshowloop = 1
			return true
		end
	end
end

function handle_input_starthelpmode(event, button)
	buttonname = get_button_name(button)
	if(buttonname == 'Button C8') then
		g_helpmode = true
		g_startflashing = true
		g_updateall = true
		return true
	end
end

function handle_input_setveltomax(event, button)
	-- Change all remaining button input to velocity 127
	if(button.z > 0 ) then
		local midi = string.format("%02x %02x", button.x, button.y)
		local item = itemsindex[midi_to_button[midi]]
       		local msg = { time_stamp = event.time_stamp, item = item, value = 1, velocity = 127 }
		remote.handle_input(msg)
		return true
	end
end
function handle_input_buttonendscroll(event, button)
	if(g_scrolling) then
		g_endscroll = true
		return false
	end
end
function handle_changed_sel(citemindex, citemname)
	for s=1,g_selcount do
		if(remote.get_item_mode(citemindex) == itemsmodeindex[citemname]["SEL"..s]) then
			g_sel[s] = tonumber(remote.get_item_value(citemindex))
		end
	end
end

function handle_changed_devicescope(citemindex, citemname)
	if(string.match(citemname, "DeviceScope")) then
		-- g_scrolltext = remote.get_item_text_value(itemsindex["DeviceScope"])
		g_updateall = true
       		if(remote.is_item_enabled(itemsindex["DeviceScope"])) then
             				local newscope = remote.get_item_text_value(itemsindex["DeviceScope"])
			g_scopetext = newscope
			g_colorscheme = g_scopetext
       		else
             				local newscope = ""
			g_scopetext = newscope
       		end
	end
end

function handle_changed_barposition(citemindex, citemname)
	if(string.match(citemname, "BarPosition")) then
		g_startbar = true
	end
end

function handle_changed_barposition(citemindex, citemname)
	if(string.match(citemname, "BeatPosition")) then
		if(not g_barupdate and not g_startbar) then
			g_startbeat = true
		end
	end
end

function handle_changed_playingstep(citemindex, citemname)
	if(string.match(citemname, "PlayingStep")) then
		if(g_scopetext == "Redrum") then
             				local playingstep = tonumber(remote.get_item_text_value(itemsindex["PlayingStep"]))
			local editsteps = math.floor(remote.get_item_value(itemsindex["UDVButton 5-8_6-8"])/42)+1
			local cstep = (playingstep-1)%16
			local cpage = math.floor(((playingstep-1))/16)+1
			local crowstep = (cstep)%8+1
			local crow = math.floor((cstep)/8)+1

			if(editsteps == cpage) then
				g_playingbutton = "Button "..tostring(crow).."-"..tostring(crowstep)
				g_updateall = true
			else
				g_playingbutton = "Other page"	
			end
		elseif(g_scopetext == "Thor") then
             				local playingstep = tonumber(remote.get_item_text_value(itemsindex["PlayingStep"]))
			local crowstep = (playingstep)%8+1
			local crow = math.floor((playingstep)/8)+1

			g_playingbutton = "Button "..tostring(crow).."-"..tostring(crowstep)
			g_updateall = true
		end
	end
end

function handle_changed_pagename(citemindex, citemname)
	if(string.match(citemname, "PageName")) then
		g_updateall = true
		if(g_scopetext == "Europa" or g_scopetext == "Grain") then
			local ceng = tonumber(string.match(get_current_page(), "Eng (%d)"))
			if(ceng ~= nil) then
				g_select["EngineSelect"] = ceng-1
			end

			local clfo = tonumber(string.match(get_current_page(), "LFO (%d)"))
			if(clfo ~= nil) then
				g_select["LFOSelect"] = clfo-1
			end

			cenv = tonumber(string.match(get_current_page(), "Env (%d)"))
			if(cenv ~= nil) then
				g_select["EnvSelect"] = cenv-1
			end

			if(string.match(get_current_page(), "Phaser")) then
				g_select["EffectSelect"] = 4
			elseif(string.match(get_current_page(), "Dist")) then
				g_select["EffectSelect"] = 2
			elseif(string.match(get_current_page(), "Eq")) then
				g_select["EffectSelect"] = 6
			elseif(string.match(get_current_page(), "Delay")) then
				g_select["EffectSelect"] = 1
			elseif(string.match(get_current_page(), "Comp")) then
				g_select["EffectSelect"] = 3
			elseif(string.match(get_current_page(), "Reverb")) then
				g_select["EffectSelect"] = 0
			end
		elseif(g_scopetext == "RV7000 Advanced Reverb") then
			if(string.match(get_current_page(), "Reverb")) then
				g_select["EditSelect"] = 0
			elseif(string.match(get_current_page(), "Eq")) then
				g_select["EditSelect"] = 1
			elseif(string.match(get_current_page(), "Gate")) then
				g_select["EditSelect"] = 2
			end
		end
	end
end

function handle_changed_subpagename(citemindex, citemname)
	if(string.match(citemname, "SubPageName")) then
		g_updateall = true
	end
end

function handle_changed_kbdvel(citemindex, citemname)
	if(string.match(citemname, "KbdVel")) then
		local newkbdvel = tonumber(remote.get_item_text_value(itemsindex["KbdVel"]))
		if(newkbdvel ~= nil) then
			g_kbdvel = newkbdvel
		end
	end
end

function handle_changed_basekey(citemindex, citemname)
	if(string.match(citemname, "BaseKey")) then
             			local newbasekey = tonumber(remote.get_item_text_value(itemsindex["BaseKey"]))
		if(newbasekey ~= nil) then
             				g_basekey = newbasekey
		end
	end
end
function deliver_midi_scrolltext(ret_events)
	if(g_scrolltext ~= nil) then
		table.insert(ret_events, remote.make_midi(gen_scroll_string(g_scrolltext, g_scrollcolor, g_scrollspeed)))
		g_scrolling = true
		g_scrolltime = remote.get_time_ms()
		g_scrolltext = nil
		g_scrollcolor = g_scrollcolor_default
		g_scrollspeed = g_scrollspeed_default
	end
end

function deliver_midi_endscroll(ret_events)
	if(g_endscroll) then
		table.insert(ret_events, remote.make_midi(MIDI_OUT_ENDSCROLL))
		g_endscroll = false
		g_scrolling = false
		g_updateall = true
	end
end

function deliver_midi_sel(ret_events)
	-- If sel* is updated trigger midi event by sending get version sysex
	for s=1,g_selcount do
		if(g_sel[s] ~= nil) then
			table.insert(ret_events, remote.make_midi(MIDI_OUT_GETVERSION))
		end
	end
end
function deliver_midi_buttons(ret_events)
        if(g_lightshow == 0 and not g_flashing and not g_scrolling) then
                if(g_updateall) then
			local gridmidimsg = "f0 00 20 29 02 10 0f 00"
			for row=9,0,-1 do
				for column=0,9 do
			local buttonname
					if(row == 0) then
						buttonname = "Button C"..tostring(column)
					elseif(row == 9) then
						buttonname = "Button A"..tostring(column)
					elseif(column == 0) then
						buttonname = "Button B"..tostring(row)
					elseif(column == 9) then
						buttonname = "Button D"..tostring(row)
					else
						buttonname = "Button "..tostring(row).."-"..tostring(column)
					end
					local itemname = get_item_by_button(buttonname)
					local color = get_button_color(g_colorscheme, itemname, buttonname)
					if(string.match(itemname, "Button C8") and g_helpmode) then
						color = RED
					elseif(string.match(itemname, "Button C8") and g_valuemode) then
						color = YELLOW
					end
		
					gridmidimsg = gridmidimsg.." "..get_rgb_midi(color)
				end
			end
			gridmidimsg = gridmidimsg.." f7"
			table.insert(ret_events, remote.make_midi(gridmidimsg))
			deliver_midi_sideled(ret_events)
			g_updateall = false
		end
	end
end

function deliver_midi_sideled(ret_events)
	-- Side LED
	local sidecolor = get_rgb_midi(get_button_color(g_colorscheme, "Side LED", "Side LED"))
	if(g_helpmode) then
		sidecolor = get_rgb_midi(RED)
	elseif(g_valuemode) then
		sidecolor = get_rgb_midi(YELLOW)
	end
	table.insert(ret_events, remote.make_midi(string.format("f0 00 20 29 02 10 0b 63 %s f7", sidecolor)))
end

function deliver_midi_startflashing(ret_events)
	if(g_startflashing) then
		local flashmidi = "f0 00 20 29 02 10 23"
		local flashcolor = S_NOCOLOR
		for buttonname,buttonmidi in pairs(buttons) do
			local shortmidi = string.match(buttonmidi, ".. (..)")
			if(not string.match(buttonname, "Button C8") and not string.match(buttonname, "Button [AC][09]")) then
				flashmidi = string.format("%s %s %02x", flashmidi, shortmidi, flashcolor)
			end
		end
		flashmidi = flashmidi.." f7"
		table.insert(ret_events, remote.make_midi(flashmidi))
		g_startflashing = false
		g_flashing = true
	end
end
function remote_init()
	init_buttons()
	init_udbuttons()
	init_sel()
	init_itemsindex()
	init_miditobutton()

	remote.define_items(items)
	remote.define_auto_inputs(inputs)
end

function remote_release_from_use()
	local ret_events={}

	return ret_events;
end

function remote_prepare_for_use()
	local ret_events={}

	table.insert(ret_events, remote.make_midi(MIDI_OUT_PROGLAYOUT))

	return ret_events;
end

function remote_set_state(changed_items)
	for i,citemindex in ipairs(changed_items)do
		local citemname = items[citemindex].name

		g_updateall = true

		if(citemname ~= nil) then
			handle_changed_sel(citemindex, citemname)
			handle_changed_devicescope(citemindex, citemname)
			handle_changed_barposition(citemindex, citemname)
			handle_changed_barposition(citemindex, citemname)
			handle_changed_playingstep(citemindex, citemname)
			handle_changed_pagename(citemindex, citemname)
			handle_changed_subpagename(citemindex, citemname)
			handle_changed_kbdvel(citemindex, citemname)
			handle_changed_basekey(citemindex, citemname)
		end
	end
end

function remote_deliver_midi(maxbytes, port)
	local ret_events = {}

	if(g_stopflashing) then
		g_stopflashing = false
		g_flashing = false
		g_updateall = true
	end

	deliver_midi_buttons(ret_events)
	deliver_midi_startflashing(ret_events)
	deliver_midi_scrolltext(ret_events)
	deliver_midi_endscroll(ret_events)
	deliver_midi_sel(ret_events)

	return ret_events
end

function remote_process_midi(event)
	handle_input_sel(event)

	handle_input_select(event)

	if(handle_input_scrollend(event)) then
		return(true)
	end

	if(g_lightshow > 0) then
		if(handle_input_lightshow(event)) then
			return(true)
		end
	end

	local button = remote.match_midi("xx yy zz", event)

	if(isbutton(button)) then
		if(g_helpmode) then
			if(handle_input_helpmode(event, button)) then
				return(true)
			end
		elseif(g_valuemode) then
			if(handle_input_valuemode(event, button)) then
				return(true)
			end
		else
			if(handle_input_buttonendscroll(event, button)) then
				return(true)
			end

			if(handle_input_kong(event, button)) then
				return(true)
			end
	
			if(handle_input_keyboard(event, button)) then
				return(true)
			end
	
			if(handle_input_item(event, button)) then
				return(true)
			end

			if(handle_input_internalpage(event, button)) then
				return(true)
			end

			if(handle_input_setveltomax(event, button)) then
				return(true)
			end
	
			if(handle_input_starthelpmode(event, button)) then
				return(true)
			end

		end
	end

	if(g_helpmode or g_valuemode) then
		return true
	end

	return false
end
function match_midi_events(mask,events)
	for i,event in ipairs(events) do
		local res=remote.match_midi(mask,event)
		if res~=nil then
			return true
		end
	end
	return false
end

function remote_probe(manufacturer,model,prober)
	local dev_inq_request={remote.make_midi(MIDI_OUT_DEVICEINQ)}
	local dev_inq_response=string.format("%s %02x 00 ?? ?? ?? ?? ?? ?? f7", MIDI_IN_DEVICEINQ_HEAD, DEVICE_ID)
	local prog_layout_request={remote.make_midi(MIDI_OUT_PROGLAYOUT)}

	local LIVEPORT=1
	local STANDALONEPORT=2

        local results={}
	local lp_ports={}
	local standalone_ports={}

        for outPortIndex = 1,prober.out_ports do
                prober.midi_send_function(outPortIndex,dev_inq_request)
                prober.wait_function(50)
                for inPortIndex = 1,prober.in_ports do
                        local events=prober.midi_receive_function(inPortIndex)

                        if match_midi_events(dev_inq_response,events) then
                                table.insert(lp_ports,outPortIndex)
                        end
                end
        end

	for i,portnum in pairs(lp_ports) do
                prober.midi_send_function(portnum,prog_layout_request)
                prober.wait_function(50)
                for j,inportnum in pairs(lp_ports) do
                        local events=prober.midi_receive_function(inportnum)

                        if match_midi_events(MIDI_IN_PROGLAYOUT_STATUS,events) then
                                table.insert(standalone_ports,portnum)
                        end
                end
	end

	for i,portnum in pairs(standalone_ports) do
		table.insert(results, { in_ports={portnum}, out_ports={portnum} })
	end

        return results
end
